% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streaming.R
\name{reduce_space.array}
\alias{reduce_space.array}
\title{Apply a function over space and bands in a four-dimensional (band, time, y, x) array and reduce
spatial dimensions}
\usage{
\method{reduce_space}{array}(x, FUN, ...)
}
\arguments{
\item{x}{four-dimensional input array with dimensions band, time, y, x (in this order)}

\item{FUN}{function which receives one spatial slice in a three-dimensional array with dimensions bands, y, x as input}

\item{...}{further arguments passed to FUN}
}
\description{
Apply a function over space and bands in a four-dimensional (band, time, y, x) array and reduce
spatial dimensions
}
\details{
FUN is expected to produce a numeric vector (or scalar) where elements are interpreted as new bands in the result.
}
\note{
This is a helper function that uses the same dimension ordering as gdalcubes streaming. It can be used to simplify 
the application of R functions e.g. over spatial slices in a data cube.
}
\examples{
d <- c(4,16,32,32)
x <- array(rnorm(prod(d)), d)
# reduce individual bands over spatial slices 
y <- reduce_space(x, function(v) {
  apply(v, 1, mean)
})
dim(y)
}
