% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdi.r
\name{vCOM}
\alias{vCOM}
\title{Finds the vertical (y axis, i.e. the axis parallel to the cross-section diameter) position of the center of mass (COM) of the volume. Experimental; only valid for "raw" gdi results with segment volumes approximated as elliptical prisms, or for manually supplied segment COMs. COM is calculated as a weighted mean of all segment COMs, with the segment mass as the weighting factor. Estimates have lower accuracy compared to hCOM, because cross-sectional geometry and variation in density throughout the cross-section is not taken into account.}
\usage{
vCOM(
  y,
  volumes = NULL,
  subtract = NULL,
  densities = NULL,
  scale = 1,
  from_top = FALSE
)
}
\arguments{
\item{y}{A data.frame that is the output of gdi(..., return="all"), or a numeric vector containing vertical COM positions for segments}

\item{volumes}{An optional separate vector or data.frame (output of gdi(...,return="all") or vector of volumes.}

\item{subtract}{An optional separate vector of volumes, with length equal to the length or nrow() of x, to be subtracted from the volumes for the COM calculation.}

\item{densities}{An optional vector of segment densities, with length equal to the length or nrow() of x, to be multiplied with the volumes for the COM calculation. If both subtract and densities are supplied, the density is applied only to the "residual" volume that is left after subtraction.}

\item{scale}{Optional scale value (number of pixels to chosen unit of measurement)}

\item{from_top}{Whether the output coordinate should be measured from the top of the image (standard for image processing software), if TRUE, or from the bottom (standard for plotting in R (if FALSE, default). If TRUE, an attribute to y, containing the vertical dimension relative to which the measurement should be taken is required.}
}
\value{
An object of class numeric() containing the y coordinate of the center of mass of the shape, in pixels (or chosen units, if manually calculated)
}
\description{
Finds the vertical (y axis, i.e. the axis parallel to the cross-section diameter) position of the center of mass (COM) of the volume. Experimental; only valid for "raw" gdi results with segment volumes approximated as elliptical prisms, or for manually supplied segment COMs. COM is calculated as a weighted mean of all segment COMs, with the segment mass as the weighting factor. Estimates have lower accuracy compared to hCOM, because cross-sectional geometry and variation in density throughout the cross-section is not taken into account.
}
\examples{
fdir <- system.file(package="gdi")
measuresil(file.path(fdir,"exdata","lat.png"), return="all")->lat_
measuresil(file.path(fdir,"exdata","dors.png"), return="all")->dors_
gdi(lat_, dors_, return="all")->gdiresults
vCOM(gdiresults)
}
