% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grab_funs.R
\name{grab_design_levels}
\alias{grab_design_levels}
\title{Grab a list of the levels of factor variables in a model.}
\usage{
grab_design_levels(model)
}
\arguments{
\item{model}{a model object such as \code{lm}, \code{glm}, \code{merMod}}
}
\value{
A named list of character vectors that provides the fentire set of
levels that each factor predictor in \code{model} will take on. This is
hopefully identical to what the \code{xlev} argument to
\code{link[stats]{model.frame}} desires. When \code{model} has no factors
as predictors, then an empty list is returned.
}
\description{
Useful when splitting data later, used with \code{\link{grab_design_matrix}}
or especially when calling \code{\link{grab_psiFUN}} from within an eeFun.
}
\examples{
\dontrun{
  geex::grab_design_matrix(
    data = data,
    rhs_formula = geex::grab_fixed_formula(model),
    xlev = geex::grab_design_levels(model)
  )
  ## Below is helpful within an eeFun.
  geex::grab_psiFUN(
    data = data,## Especially when this is a subset of the data
    rhs_formula = geex::grab_fixed_formula(model),
    xlev = geex::grab_design_levels(model)
  )
}
}
