% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/velocity.R
\name{pso.velocity}
\alias{pso.velocity}
\title{Velocity}
\usage{
pso.velocity(
  population,
  method = "hypersphere",
  par = list(w = 1/(2 * log(2)), c1 = 0.5 + log(2), c2 = 0.5 + log(2)),
  velocity,
  best.pn,
  best.nh,
  best.pn.fitness,
  best.nh.fitness,
  iter = 1
)
}
\arguments{
\item{population}{numeric matrix which rows are particles i.e. vectors of 
parameters values.}

\item{method}{string representing method to be used for velocities 
calculation. See 'Details' for additional information.}

\item{par}{additional parameters to be passed depending on the \code{method}.}

\item{velocity}{matrix which i-th row is a velocity of the i-th particle.}

\item{best.pn}{numeric matrix which i-th row is a best personal position 
known by the i-th particle.}

\item{best.nh}{numeric matrix which i-th row is a best personal position 
in a neighbourhood of the i-th particle.}

\item{best.pn.fitness}{numeric vector which i-th row is the value of
a fitness function at point \code{best.pn[i, ]}.}

\item{best.nh.fitness}{numeric vector which i-th row is the value of
a fitness function at point \code{best.nh[i, ]}.}

\item{iter}{iteration number of the genetic algorithm.}
}
\value{
This function returns a matrix which i-th row represents
updated velocity of the i-th particle.
}
\description{
Calculates (updates) velocities of the particles.
}
\details{
If \code{method = "classic"} then classical velocity formula
is used:
\deqn{v_{i,j,(t+1)}=w\times v_{i,j,t} + 
                     c_{1}\times u_{1,i,j} \times b^{pn}_{i,j,t} + 
                     c_{2}\times u_{2,i,j} \times b^{nh}_{i,j,t}}
                     
 where \eqn{v_{i, j, t}} is a velocity of the \eqn{i}-th particle 
 respect to the \eqn{j}-th component at time \eqn{t}. Random variables
 \eqn{u_{1,i,j}} and \eqn{u_{2,i,j}} are i.i.d. respect to all indexes and
 follow standard uniform distribution \eqn{U(0, 1)}. 
 Variable \eqn{b^{pn}_{i,j,t}} is \eqn{j}-th component of the best known
 particle's (personal) position up to time period \eqn{t}. 
 Similarly \eqn{b^{nh}_{i,j,t}} is \eqn{j}-th component of the best of best 
 known particle's position in a neighbourhood of the \eqn{i}-th particle.
 Hyperparameters \eqn{w}, \eqn{c_{1}} and \eqn{c_{2}} may be provided
 via \code{par} argument as a list with elements \code{par$w}, \code{par$c1}
 and \code{par$c2} correspondingly. 
 
 If \code{method = "hypersphere"} then rotation invariant formula from
 sections 3.4.2 and 3.4.3 of M. Clerc (2012) is used with arguments
 identical to the classical method. To simulate a random variate from
 the hypersphere function \code{\link[gena]{rhypersphere}} is used
 setting \code{type = "non-uniform"}.
 
 In accordance with M. Clerc (2012) 
 default values are \code{par$w = 1/(2 * log(2))},
 \code{par$c1 = 0.5 + log(2)} and \code{par$c2 = 0.5 + log(2)}.
}
\references{
Maurice Clerc (2012). 
Standard Particle Swarm Optimisation.
\emph{HAL archieve}.
}
