% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneQTL.R
\name{geneQTL}
\alias{geneQTL}
\title{Identifies Candidate Genes based on identified Quantitative Trati Loci (QTL) analysis}
\usage{
geneQTL(data_file, crop = "wheat")
}
\arguments{
\item{data_file}{The input data in .csv format. (sample_data_wheat_qtl or sample_data_rice_qtl for demo purpose)}

\item{crop}{Either "wheat" or "rice". (by default it will be wheat)}
}
\value{
A data frame containing traits, QTL, gene_id, gene_size, and gene_type.
}
\description{
Identifies Candidate Genes based on identified Quantitative Trati Loci (QTL) analysis
}
\examples{
load(system.file("extdata", "precomputed_sample_results_qtl.rda", package = "geneNR"))
message(sample_results)
\donttest{
result <- geneQTL("sample_data_wheat_qtl", crop="wheat")
result <- geneQTL("sample_data_rice_qtl", crop="rice")
#result <- geneQTL("your_results.csv", crop="wheat")
}
}
