% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_summariseSNP.R
\name{plot_summariseSNP}
\alias{plot_summariseSNP}
\title{Plot SNP Distribution Across Chromosomes}
\usage{
plot_summariseSNP(
  snp_distribution,
  file_name = "snp_bar_chart.jpeg",
  output_dir = tempdir(),
  bar_color = "lightblue",
  label_size = 3,
  label_color = "black"
)
}
\arguments{
\item{snp_distribution}{A data frame with columns \code{Chr} and \code{SNP_Count}.}

\item{file_name}{The name of the file to save the plot (default: "snp_bar_chart.jpeg").}

\item{output_dir}{The directory to save the file (default: \code{tempdir()}).}

\item{bar_color}{The color of the bars (default: "lightblue").}

\item{label_size}{The size of the text labels on the bars (default: 3).}

\item{label_color}{The color of the text labels on the bars (default: "black").}
}
\value{
A \code{ggplot} object for the created bar chart.
}
\description{
Creates a bar chart representing the distribution of SNPs across chromosomes.
Allows customization of bar color, label size, and label color. Saves the plot to a user-specified directory or a temporary directory.
}
\examples{
\donttest{
demo_SNP <- system.file("extdata", "demo_SNP.hmp.txt", package = "geneNR")
data <- import_hmp(demo_SNP)
snp_distribution <- summariseSNP(data)
plot <- plot_summariseSNP(snp_distribution, bar_color = "skyblue",
label_size = 3, label_color = "red")
print(plot)
}
}
