% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GGE_Model.R
\name{GGEmodel}
\alias{GGEmodel}
\title{Site Regression model}
\usage{
GGEmodel(
  Data,
  genotype = "gen",
  environment = "env",
  response = "yield",
  rep = NULL,
  model = "SREG",
  SVP = "symmetrical"
)
}
\arguments{
\item{Data}{dataframe with genotypes, environments, repetitions (if any) and
the phenotypic trait of interest. Additional variables that will not be used
in the model may be present in the data.}

\item{genotype}{column name for genotypes.}

\item{environment}{column name for environments.}

\item{response}{column name for the phenotypic trait.}

\item{rep}{column name for replications. If this argument is NULL, there are
no replications in the data. Defaults to NULL.}

\item{model}{method for fitting the SREG model: `"SREG"`,`"CovSREG"`,`"hSREG"`
or `"ppSREG"` (see References). Defaults to `"SREG"`.}

\item{SVP}{method for singular value partitioning. Either `"row"`, `"column"`,
or `"symmetrical"`. Defaults to `"symmetrical"`.}
}
\value{
A list of class \code{GGE_Model} containing: \item{model}{SREG model
 version.} \item{coordgenotype}{plotting coordinates for each genotype in
 every component.} \item{coordenviroment}{plotting coordinates for each
 environment in every component.} \item{eigenvalues}{vector of eigenvalues
 for each component.} \item{vartotal}{overall variance.}
 \item{varexpl}{percentage of variance explained by each component.}
 \item{labelgen}{genotype names.} \item{labelenv}{environment names.}
 \item{axes}{axis labels.} \item{Data}{scaled and centered input data.}
 \item{SVP}{name of SVP method.}

A biplot of class \code{ggplot}
}
\description{
The Site Regression model (also called genotype +
 genotype-by-environment (GGE) model) is a powerful tool for effective
 analysis and interpretation of data from multi-environment trials in
 breeding programs. There are different functions in R to fit the SREG model,
 such as the \code{\link[GGEBiplots]{GGEModel}} from the
 \href{https://CRAN.R-project.org/package=GGEBiplots}{GGEBiplots package}.
 However, this function has the following improvements: \itemize{ \item
 Includes recently published robust versions of the SREG model (Angelini et
 al., 2022). \item It can be used for data from trials with repetitions
 (there is no need to calculate means beforehand). \item Other variables not
 used in the analysis can be present in the dataset.}
}
\details{
A linear model by robust regression using an M estimator proposed by
 Huber (1964, 1973) fitted by iterated re-weighted least squares, in
 combination with three robust SVD/PCA procedures, resulted in a total of
 three robust SREG alternatives. The robust SVD/PCA considered were:
 \itemize{ \item CovSREG: robust PCA that is obtained by replacing the
 classical estimates of location and covariance by their robust analogues
 using Minimum Regularized Covariance Determinant (MRCD) approach; \item
 hSREG: robust PCA method that tries to combine the advantages of both
 approaches, PCA based on a robust covariance matrix and based on projection
 pursuit; \item ppSREG: robust PCA that uses the projection pursuit and
 directly calculates the robust estimates of the eigenvalues and eigenvectors
 without going through robust covariance estimation. It is a very attractive
 method for bigdata situations, which are very common in METs (a few
 genotypes tested in a large number of environments), as the principal
 components can be calculated sequentially. }
}
\examples{
 library(geneticae)

 # Data without replication
 library(agridat)
 data(yan.winterwheat)
 GGE1 <- GGEmodel(yan.winterwheat, genotype="gen", environment="env", response="yield")

 # Data with replication
 data(plrv)
 GGE2 <- GGEmodel(plrv, genotype = "Genotype", environment = "Locality",
                  response = "Yield", rep = "Rep")

}
\references{
Julia Angelini, Gabriela Faviere, Eugenia Bortolotto, Gerardo
 Domingo Lucio Cervigni & Marta Beatriz Quaglino (2022) Handling outliers in
 multi-environment trial data analysis: in the direction of robust SREG
 model, Journal of Crop Improvement, DOI: 10.1080/15427528.2022.2051217
}
