% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneviewer.R
\name{GC_clusterTitle}
\alias{GC_clusterTitle}
\title{Update cluster Title of a GC Chart Cluster}
\usage{
GC_clusterTitle(
  GC_chart,
  title = NULL,
  subtitle = NULL,
  subtitleFont = list(),
  titleFont = list(),
  show = TRUE,
  height = NULL,
  cluster = NULL,
  ...
)
}
\arguments{
\item{GC_chart}{A GC chart object.}

\item{title}{Character vector. Titles to set for the clusters.}

\item{subtitle}{Character vector. Subtitles to set for the clusters.}

\item{subtitleFont}{List. Settings for the subtitle font.}

\item{titleFont}{List. Settings for the title font.}

\item{show}{Logical. Whether to display the title. Default is TRUE.}

\item{height}{Character. Height for the title (e.g., "40px").}

\item{cluster}{Numeric or character vector. Clusters in the GC chart to update.}

\item{...}{Additional customization arguments for title and subtitle.}
}
\value{
Updated GC chart with new title settings.
}
\description{
Modify the cluster title and subtitle of specified clusters within a GC chart and adjust
the display settings.
}
\examples{
genes_data <- data.frame(
  start = c(10, 50, 90, 130, 170, 210),
  end = c(40, 80, 120, 160, 200, 240),
  name = c('Gene 1', 'Gene 2', 'Gene 3', 'Gene 4', 'Gene 5', 'Gene 6'),
  group = c('A', 'A', 'B', 'B', 'A', 'C'),
  cluster = c(1, 1, 1, 2, 2, 2)
)

# Basic usage
GC_chart(genes_data, cluster ="cluster", group = "group", height = "400px") \%>\%
GC_labels("name") \%>\%
GC_clusterTitle(
  title = "Cluster 1 Data",
  subtitle = "Detailed View",
  show = TRUE,
  cluster = 1
)

# Customizing title style
GC_chart(genes_data, cluster = "cluster", group = "group", height = "400px") \%>\%
  GC_labels("name") \%>\%
  GC_clusterTitle(
    title = "Cluster 1 Data",
    subtitle = "Detailed View",
    show = TRUE,
    cluster = 1,
    x = 0,
    y = 5,
    align = "center",
    spacing = 20,
    titleFont = list(
      fontSize = "16px",
      fontStyle = "normal",
      fontWeight = "bold",
      textDecoration = "normal",
      fontFamily = "sans-serif",
      cursor = "default",
      fill = "black"
      # Any other CSS styles
    ),
    subtitleFont = list(
      fontSize = "14px",
      fontStyle = "normal",
      fontWeight = "bold",
      textDecoration = "normal",
      fontFamily = "sans-serif",
      cursor = "default",
      fill = "black"
      # Any other CSS styles
    )
  )
}
