% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneviewer.R
\name{GC_trackMouse}
\alias{GC_trackMouse}
\title{Track Mouse Movement in a GC_chart}
\usage{
GC_trackMouse(GC_chart, show = TRUE, cluster = NULL)
}
\arguments{
\item{GC_chart}{A GC chart object to which the annotations will be added.}

\item{show}{Logical, specifies whether to track the mouse or not.}

\item{cluster}{Numeric or character vector specifying the clusters to which
annotations should be added.}
}
\value{
Updated GC chart object with mouse tracking settings.
}
\description{
This function enables or disables mouse tracking on specified clusters within
a GC chart. When enabled, the x and y coordinates of the mouse are displayed
which can be used to place annotations.
}
\examples{
genes_data <- data.frame(
  start = c(10, 50, 90, 130, 170, 210),
  end = c(40, 80, 120, 160, 200, 240),
  name = c('Gene 1', 'Gene 2', 'Gene 3', 'Gene 4', 'Gene 5', 'Gene 6'),
  group = c('A', 'A', 'B', 'B', 'A', 'C'),
  cluster = c(1, 1, 1, 2, 2, 2)
)

# Enable mouse tracking
GC_chart(genes_data, cluster = "cluster", group = "group", height = "220px") \%>\%
GC_trackMouse()

}
\seealso{
\code{\link{GC_annotation}}
}
