% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneviewer.R
\name{GC_chart}
\alias{GC_chart}
\title{Create a GC Chart Visualization}
\usage{
GC_chart(
  data,
  start = "start",
  end = "end",
  cluster = NULL,
  group = NULL,
  strand = NULL,
  width = "100\%",
  height = "400px",
  style = list(),
  elementId = NULL,
  save_button = TRUE
)
}
\arguments{
\item{data}{Data frame containing genomic information or the file path to a
folder containing `.gbk` files. When providing a file path, the data is
loaded and processed into a data frame internally.}

\item{start}{Column name that indicates start positions. Default is "start".}

\item{end}{Column name that indicates end positions. Default is "end".}

\item{cluster}{Optional column name used for clustering purposes. Default is
NULL.}

\item{group}{Column name used for gene grouping to influence color
aesthetics.}

\item{strand}{Optional column name indicating strand orientation. Acceptable
values include 1, 'forward', 'sense', or '+' to represent the forward
strand, and -1, 0, 'reverse', 'antisense', "complement" or '-' to represent
the reverse strand. Default is NULL, meaning strand information is not
used.}

\item{width}{Width specification for the chart, such as '100\%' or 500.
Default is unspecified.}

\item{height}{Height specification for the chart, such as '400px' or 300.
Default is unspecified.}

\item{style}{A list of CSS styles to be applied to the chart container. Each
element of the list should be a valid CSS property-value pair. For example,
list(backgroundColor = "white", border = "2px solid black"). Default is an
empty list.}

\item{elementId}{Optional identifier string for the widget. Default is NULL.}

\item{save_button}{Logical, whether to include a save button. Default is TRUE.}
}
\value{
A GC chart widget.
}
\description{
Generates an interactive GC chart for genomic data.
}
\examples{
genes_data <- data.frame(
  start = c(10, 50, 90, 130, 170, 210),
  end = c(40, 80, 120, 160, 200, 240),
  name = c('Gene 1', 'Gene 2', 'Gene 3', 'Gene 4', 'Gene 5', 'Gene 6'),
  group = c('A', 'A', 'B', 'B', 'A', 'C'),
  cluster = c(1, 1, 1, 2, 2, 2)
)
# Load from data.frame
GC_chart(genes_data, group = "group", cluster = "cluster", height = "200px") \%>\%
GC_labels("name")

# Load from folder containing .gbk files
# file_path <- "~/path/to/folder/"
# GC_chart(file_path) \%>\%

}
