\name{MO}
\alias{dMO}
\alias{pMO}
\alias{qMO}
\alias{rMO}
\alias{dMO2}
\alias{pMO2}
\alias{qMO2}
\alias{rMO2}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
The Marshall-Olkin and Marshall-Olkin of the second kind distributions
}
\description{
Density, distribution function, quantile function and random generation for the Marshall-Olkin (MO) and Marshall-Olkin of the second kind (MO2) distributions.
}
\usage{
dMO(x, theta = 1, log = FALSE)
pMO(q, theta = 1, lower.tail = TRUE, log.p = FALSE)
qMO(p, theta = 1, lower.tail = TRUE, log.p = FALSE)
rMO(n, theta = 1)
dMO2(x, theta = 1, log = FALSE)
pMO2(q, theta = 1, lower.tail = TRUE, log.p = FALSE)
qMO2(p, theta = 1, lower.tail = TRUE, log.p = FALSE)
rMO2(n, theta = 1)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x, q}{
vector of quantiles.
}
  \item{p}{
vector of probabilities.
}
  \item{n}{
number of observations. If length(n) > 1, the length is taken to be the number required.
}
\item{theta}{
shape parameter (by default is 1).
}
\item{log, log.p}{
logical; if TRUE, probabilities p are given as log(p).
}
\item{lower.tail}{
logical; if TRUE (default), probabilities are \eqn{P[X\leq x]}, otherwise \eqn{P[X>x]}. 
}
}
\details{
The MO model has cumulative distribution function
\deqn{
F(x;\alpha)=\frac{\theta x}{1-(1-\theta)x}, \quad x \in (0,1), \theta>0,
}
whereas the MO2 model has cumulative distribution function
\deqn{
F(x;\alpha)=\frac{x}{1-(1-\theta)(1-x)}, \quad x \in (0,1), \alpha>0,
}
}
\value{
dEXP and dEXP2 give the density, pEXP and pEXP2 give the distribution function, qEXP and qEXP2 give the quantile function, and rEXP and rEXP2 generate random deviates.
The length of the result is determined by n for rcompound, and is the maximum of the lengths of the numerical arguments for the other functions.
The numerical arguments other than n are recycled to the length of the result. Only the first elements of the logical arguments are used.
}
%\references{
%% ~put references to the literature/web site here ~
%}
\author{
Yolanda M. Gomez, Diego I. Gallardo, Hector W. Gomez and Barry Arnold
}
%\note{
%%  ~~further notes~~
%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

%\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
%}
\examples{
set.seed(2100)
y=rMO(100, theta = 1.2)
}

