% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOServiceIdentification.R
\docType{class}
\name{ISOSRVServiceIdentification19115_3}
\alias{ISOSRVServiceIdentification19115_3}
\title{ISOSRVServiceIdentification19115_3}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} for modelling an ISO SRV ServiceIdentification in ISO 19115-3
}
\description{
ISOSRVServiceIdentification19115_3

ISOSRVServiceIdentification19115_3
}
\keyword{ISO}
\keyword{identification}
\keyword{service}
\section{Super classes}{
\code{\link[geometa:geometaLogger]{geometa::geometaLogger}} -> \code{\link[geometa:ISOAbstractObject]{geometa::ISOAbstractObject}} -> \code{\link[geometa:ISOIdentification]{geometa::ISOIdentification}} -> \code{\link[geometa:ISOIdentification19115_3]{geometa::ISOIdentification19115_3}} -> \code{\link[geometa:ISOServiceIdentification19115_3]{geometa::ISOServiceIdentification19115_3}} -> \code{ISOSRVServiceIdentification19115_3}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{serviceType}}{serviceType [1..1]: ISOGenericName}

\item{\code{serviceTypeVersion}}{serviceTypeVersion [0..*]: character}

\item{\code{accessProperties}}{accessProperties [0..1]: ISOStandardOrderProcess}

\item{\code{restrictions}}{restrictions [0..1]: ISOConstraints}

\item{\code{keywords}}{keywords [0..*]: ISOKeywords}

\item{\code{extent}}{extent [0..*]: ISOExtent}

\item{\code{coupledResource}}{coupledResource [0..*]: ISOCoupledResource}

\item{\code{couplingType}}{couplingType [1..1]: ISOCouplingType}

\item{\code{containsOperations}}{containsOperations [1..*]: ISOOperationMetadata}

\item{\code{operatesOn}}{operatesOn [0..*]: ISODataIdentification}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ISOSRVServiceIdentification19115_3-new}{\code{ISOSRVServiceIdentification19115_3$new()}}
\item \href{#method-ISOSRVServiceIdentification19115_3-setServiceType}{\code{ISOSRVServiceIdentification19115_3$setServiceType()}}
\item \href{#method-ISOSRVServiceIdentification19115_3-addServiceTypeVersion}{\code{ISOSRVServiceIdentification19115_3$addServiceTypeVersion()}}
\item \href{#method-ISOSRVServiceIdentification19115_3-delServiceTypeVersion}{\code{ISOSRVServiceIdentification19115_3$delServiceTypeVersion()}}
\item \href{#method-ISOSRVServiceIdentification19115_3-setAccessProperties}{\code{ISOSRVServiceIdentification19115_3$setAccessProperties()}}
\item \href{#method-ISOSRVServiceIdentification19115_3-setRestrictions}{\code{ISOSRVServiceIdentification19115_3$setRestrictions()}}
\item \href{#method-ISOSRVServiceIdentification19115_3-addKeywords}{\code{ISOSRVServiceIdentification19115_3$addKeywords()}}
\item \href{#method-ISOSRVServiceIdentification19115_3-delKeywords}{\code{ISOSRVServiceIdentification19115_3$delKeywords()}}
\item \href{#method-ISOSRVServiceIdentification19115_3-addExtent}{\code{ISOSRVServiceIdentification19115_3$addExtent()}}
\item \href{#method-ISOSRVServiceIdentification19115_3-delExtent}{\code{ISOSRVServiceIdentification19115_3$delExtent()}}
\item \href{#method-ISOSRVServiceIdentification19115_3-addCoupledResource}{\code{ISOSRVServiceIdentification19115_3$addCoupledResource()}}
\item \href{#method-ISOSRVServiceIdentification19115_3-delCoupledResource}{\code{ISOSRVServiceIdentification19115_3$delCoupledResource()}}
\item \href{#method-ISOSRVServiceIdentification19115_3-setCouplingType}{\code{ISOSRVServiceIdentification19115_3$setCouplingType()}}
\item \href{#method-ISOSRVServiceIdentification19115_3-addOperationMetadata}{\code{ISOSRVServiceIdentification19115_3$addOperationMetadata()}}
\item \href{#method-ISOSRVServiceIdentification19115_3-delOperationMetadata}{\code{ISOSRVServiceIdentification19115_3$delOperationMetadata()}}
\item \href{#method-ISOSRVServiceIdentification19115_3-addOperatesOn}{\code{ISOSRVServiceIdentification19115_3$addOperatesOn()}}
\item \href{#method-ISOSRVServiceIdentification19115_3-delOperatesOn}{\code{ISOSRVServiceIdentification19115_3$delOperatesOn()}}
\item \href{#method-ISOSRVServiceIdentification19115_3-clone}{\code{ISOSRVServiceIdentification19115_3$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="ERROR"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-ERROR'><code>geometa::geometaLogger$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="INFO"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-INFO'><code>geometa::geometaLogger$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="WARN"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-WARN'><code>geometa::geometaLogger$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addFieldAttrs"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addFieldAttrs'><code>geometa::ISOAbstractObject$addFieldAttrs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addListElement'><code>geometa::ISOAbstractObject$addListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="checkMetadataStandardCompliance"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-checkMetadataStandardCompliance'><code>geometa::ISOAbstractObject$checkMetadataStandardCompliance()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="contains"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-contains'><code>geometa::ISOAbstractObject$contains()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="createLocalisedProperty"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-createLocalisedProperty'><code>geometa::ISOAbstractObject$createLocalisedProperty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="decode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-decode'><code>geometa::ISOAbstractObject$decode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="delListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-delListElement'><code>geometa::ISOAbstractObject$delListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="encode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-encode'><code>geometa::ISOAbstractObject$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClass"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClass'><code>geometa::ISOAbstractObject$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClassName"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClassName'><code>geometa::ISOAbstractObject$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getNamespaceDefinition"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getNamespaceDefinition'><code>geometa::ISOAbstractObject$getNamespaceDefinition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isDocument"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isDocument'><code>geometa::ISOAbstractObject$isDocument()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isFieldInheritedFrom"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isFieldInheritedFrom'><code>geometa::ISOAbstractObject$isFieldInheritedFrom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="print"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-print'><code>geometa::ISOAbstractObject$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="save"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-save'><code>geometa::ISOAbstractObject$save()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setAttr"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setAttr'><code>geometa::ISOAbstractObject$setAttr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeList"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeList'><code>geometa::ISOAbstractObject$setCodeList()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeListValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeListValue'><code>geometa::ISOAbstractObject$setCodeListValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeSpace"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeSpace'><code>geometa::ISOAbstractObject$setCodeSpace()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setHref"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setHref'><code>geometa::ISOAbstractObject$setHref()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setId"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setId'><code>geometa::ISOAbstractObject$setId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setIsNull"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setIsNull'><code>geometa::ISOAbstractObject$setIsNull()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setValue'><code>geometa::ISOAbstractObject$setValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="stopIfMetadataStandardIsNot"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-stopIfMetadataStandardIsNot'><code>geometa::ISOAbstractObject$stopIfMetadataStandardIsNot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="validate"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-validate'><code>geometa::ISOAbstractObject$validate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="wrapBaseElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-wrapBaseElement'><code>geometa::ISOAbstractObject$wrapBaseElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19115_3" data-id="addAdditionalDocumentation"><a href='../../geometa/html/ISOIdentification19115_3.html#method-ISOIdentification19115_3-addAdditionalDocumentation'><code>geometa::ISOIdentification19115_3$addAdditionalDocumentation()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19115_3" data-id="addAssociatedResource"><a href='../../geometa/html/ISOIdentification19115_3.html#method-ISOIdentification19115_3-addAssociatedResource'><code>geometa::ISOIdentification19115_3$addAssociatedResource()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19115_3" data-id="addCredit"><a href='../../geometa/html/ISOIdentification19115_3.html#method-ISOIdentification19115_3-addCredit'><code>geometa::ISOIdentification19115_3$addCredit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19115_3" data-id="addFormat"><a href='../../geometa/html/ISOIdentification19115_3.html#method-ISOIdentification19115_3-addFormat'><code>geometa::ISOIdentification19115_3$addFormat()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19115_3" data-id="addGraphicOverview"><a href='../../geometa/html/ISOIdentification19115_3.html#method-ISOIdentification19115_3-addGraphicOverview'><code>geometa::ISOIdentification19115_3$addGraphicOverview()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19115_3" data-id="addPointOfContact"><a href='../../geometa/html/ISOIdentification19115_3.html#method-ISOIdentification19115_3-addPointOfContact'><code>geometa::ISOIdentification19115_3$addPointOfContact()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19115_3" data-id="addResourceConstraints"><a href='../../geometa/html/ISOIdentification19115_3.html#method-ISOIdentification19115_3-addResourceConstraints'><code>geometa::ISOIdentification19115_3$addResourceConstraints()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19115_3" data-id="addResourceMaintenance"><a href='../../geometa/html/ISOIdentification19115_3.html#method-ISOIdentification19115_3-addResourceMaintenance'><code>geometa::ISOIdentification19115_3$addResourceMaintenance()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19115_3" data-id="addResourceSpecificUsage"><a href='../../geometa/html/ISOIdentification19115_3.html#method-ISOIdentification19115_3-addResourceSpecificUsage'><code>geometa::ISOIdentification19115_3$addResourceSpecificUsage()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19115_3" data-id="addSpatialRepresentationType"><a href='../../geometa/html/ISOIdentification19115_3.html#method-ISOIdentification19115_3-addSpatialRepresentationType'><code>geometa::ISOIdentification19115_3$addSpatialRepresentationType()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19115_3" data-id="addSpatialResolution"><a href='../../geometa/html/ISOIdentification19115_3.html#method-ISOIdentification19115_3-addSpatialResolution'><code>geometa::ISOIdentification19115_3$addSpatialResolution()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19115_3" data-id="addStatus"><a href='../../geometa/html/ISOIdentification19115_3.html#method-ISOIdentification19115_3-addStatus'><code>geometa::ISOIdentification19115_3$addStatus()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19115_3" data-id="addTemporalResolution"><a href='../../geometa/html/ISOIdentification19115_3.html#method-ISOIdentification19115_3-addTemporalResolution'><code>geometa::ISOIdentification19115_3$addTemporalResolution()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19115_3" data-id="addTopicCategory"><a href='../../geometa/html/ISOIdentification19115_3.html#method-ISOIdentification19115_3-addTopicCategory'><code>geometa::ISOIdentification19115_3$addTopicCategory()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19115_3" data-id="delAdditionalDocumentation"><a href='../../geometa/html/ISOIdentification19115_3.html#method-ISOIdentification19115_3-delAdditionalDocumentation'><code>geometa::ISOIdentification19115_3$delAdditionalDocumentation()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19115_3" data-id="delAssociatedResource"><a href='../../geometa/html/ISOIdentification19115_3.html#method-ISOIdentification19115_3-delAssociatedResource'><code>geometa::ISOIdentification19115_3$delAssociatedResource()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19115_3" data-id="delCredit"><a href='../../geometa/html/ISOIdentification19115_3.html#method-ISOIdentification19115_3-delCredit'><code>geometa::ISOIdentification19115_3$delCredit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19115_3" data-id="delFormat"><a href='../../geometa/html/ISOIdentification19115_3.html#method-ISOIdentification19115_3-delFormat'><code>geometa::ISOIdentification19115_3$delFormat()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19115_3" data-id="delGraphicOverview"><a href='../../geometa/html/ISOIdentification19115_3.html#method-ISOIdentification19115_3-delGraphicOverview'><code>geometa::ISOIdentification19115_3$delGraphicOverview()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19115_3" data-id="delPointOfContact"><a href='../../geometa/html/ISOIdentification19115_3.html#method-ISOIdentification19115_3-delPointOfContact'><code>geometa::ISOIdentification19115_3$delPointOfContact()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19115_3" data-id="delResourceConstraints"><a href='../../geometa/html/ISOIdentification19115_3.html#method-ISOIdentification19115_3-delResourceConstraints'><code>geometa::ISOIdentification19115_3$delResourceConstraints()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19115_3" data-id="delResourceMaintenance"><a href='../../geometa/html/ISOIdentification19115_3.html#method-ISOIdentification19115_3-delResourceMaintenance'><code>geometa::ISOIdentification19115_3$delResourceMaintenance()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19115_3" data-id="delResourceSpecificUsage"><a href='../../geometa/html/ISOIdentification19115_3.html#method-ISOIdentification19115_3-delResourceSpecificUsage'><code>geometa::ISOIdentification19115_3$delResourceSpecificUsage()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19115_3" data-id="delSpatialRepresentationType"><a href='../../geometa/html/ISOIdentification19115_3.html#method-ISOIdentification19115_3-delSpatialRepresentationType'><code>geometa::ISOIdentification19115_3$delSpatialRepresentationType()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19115_3" data-id="delSpatialResolution"><a href='../../geometa/html/ISOIdentification19115_3.html#method-ISOIdentification19115_3-delSpatialResolution'><code>geometa::ISOIdentification19115_3$delSpatialResolution()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19115_3" data-id="delStatus"><a href='../../geometa/html/ISOIdentification19115_3.html#method-ISOIdentification19115_3-delStatus'><code>geometa::ISOIdentification19115_3$delStatus()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19115_3" data-id="delTemporalResolution"><a href='../../geometa/html/ISOIdentification19115_3.html#method-ISOIdentification19115_3-delTemporalResolution'><code>geometa::ISOIdentification19115_3$delTemporalResolution()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19115_3" data-id="delTopicCategory"><a href='../../geometa/html/ISOIdentification19115_3.html#method-ISOIdentification19115_3-delTopicCategory'><code>geometa::ISOIdentification19115_3$delTopicCategory()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19115_3" data-id="setAbstract"><a href='../../geometa/html/ISOIdentification19115_3.html#method-ISOIdentification19115_3-setAbstract'><code>geometa::ISOIdentification19115_3$setAbstract()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19115_3" data-id="setCitation"><a href='../../geometa/html/ISOIdentification19115_3.html#method-ISOIdentification19115_3-setCitation'><code>geometa::ISOIdentification19115_3$setCitation()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19115_3" data-id="setProcessingLevel"><a href='../../geometa/html/ISOIdentification19115_3.html#method-ISOIdentification19115_3-setProcessingLevel'><code>geometa::ISOIdentification19115_3$setProcessingLevel()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19115_3" data-id="setPurpose"><a href='../../geometa/html/ISOIdentification19115_3.html#method-ISOIdentification19115_3-setPurpose'><code>geometa::ISOIdentification19115_3$setPurpose()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19115_3-new"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19115_3-new}{}}}
\subsection{Method \code{new()}}{
Initializes object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19115_3$new(xml = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link[XML]{XMLInternalNode-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19115_3-setServiceType"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19115_3-setServiceType}{}}}
\subsection{Method \code{setServiceType()}}{
Set service type
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19115_3$setServiceType(serviceType)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{serviceType}}{object of class \link{ISOLocalName}, \link{ISOScopedName} or \link{character}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19115_3-addServiceTypeVersion"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19115_3-addServiceTypeVersion}{}}}
\subsection{Method \code{addServiceTypeVersion()}}{
Adds service type version
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19115_3$addServiceTypeVersion(version)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{version}}{version}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19115_3-delServiceTypeVersion"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19115_3-delServiceTypeVersion}{}}}
\subsection{Method \code{delServiceTypeVersion()}}{
Deletes service type version
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19115_3$delServiceTypeVersion(version)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{version}}{version}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19115_3-setAccessProperties"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19115_3-setAccessProperties}{}}}
\subsection{Method \code{setAccessProperties()}}{
Set access properties
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19115_3$setAccessProperties(accessProperties)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{accessProperties}}{object of class \link{ISOStandardOrderProcess}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19115_3-setRestrictions"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19115_3-setRestrictions}{}}}
\subsection{Method \code{setRestrictions()}}{
Set restrictions
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19115_3$setRestrictions(restrictions)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{restrictions}}{object of class \link{ISOConstraints}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19115_3-addKeywords"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19115_3-addKeywords}{}}}
\subsection{Method \code{addKeywords()}}{
Adds keywords
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19115_3$addKeywords(keywords)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keywords}}{object of class \link{ISOKeywords}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19115_3-delKeywords"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19115_3-delKeywords}{}}}
\subsection{Method \code{delKeywords()}}{
Deletes keywords
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19115_3$delKeywords(keywords)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keywords}}{object of class \link{ISOKeywords}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19115_3-addExtent"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19115_3-addExtent}{}}}
\subsection{Method \code{addExtent()}}{
Adds extent
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19115_3$addExtent(extent)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{extent}}{object of class \link{ISOExtent}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19115_3-delExtent"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19115_3-delExtent}{}}}
\subsection{Method \code{delExtent()}}{
Deletes extent
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19115_3$delExtent(extent)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{extent}}{object of class \link{ISOExtent}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19115_3-addCoupledResource"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19115_3-addCoupledResource}{}}}
\subsection{Method \code{addCoupledResource()}}{
Adds coupled resource
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19115_3$addCoupledResource(resource)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resource}}{object of class \link{ISOCoupledResource}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19115_3-delCoupledResource"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19115_3-delCoupledResource}{}}}
\subsection{Method \code{delCoupledResource()}}{
Deletes coupled resource
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19115_3$delCoupledResource(resource)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resource}}{object of class \link{ISOCoupledResource}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19115_3-setCouplingType"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19115_3-setCouplingType}{}}}
\subsection{Method \code{setCouplingType()}}{
Set coupling type
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19115_3$setCouplingType(couplingType)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{couplingType}}{object of class \link{ISOCouplingType} or any \link{character}
among values returned by \code{ISOCouplingType$values()}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19115_3-addOperationMetadata"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19115_3-addOperationMetadata}{}}}
\subsection{Method \code{addOperationMetadata()}}{
Adds operation metadata
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19115_3$addOperationMetadata(operationMetadata)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{operationMetadata}}{object of class \link{ISOOperationMetadata}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19115_3-delOperationMetadata"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19115_3-delOperationMetadata}{}}}
\subsection{Method \code{delOperationMetadata()}}{
Deletes operation metadata
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19115_3$delOperationMetadata(operationMetadata)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{operationMetadata}}{object of class \link{ISOOperationMetadata}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19115_3-addOperatesOn"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19115_3-addOperatesOn}{}}}
\subsection{Method \code{addOperatesOn()}}{
Adds operates on
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19115_3$addOperatesOn(dataIdentification)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataIdentification}}{object of class \link{ISODataIdentification}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19115_3-delOperatesOn"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19115_3-delOperatesOn}{}}}
\subsection{Method \code{delOperatesOn()}}{
Deletes operates on
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19115_3$delOperatesOn(dataIdentification)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataIdentification}}{object of class \link{ISODataIdentification}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19115_3-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19115_3-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19115_3$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
