% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10-terrain-analysis.R
\name{calculate_advanced_terrain_metrics}
\alias{calculate_advanced_terrain_metrics}
\title{Calculate advanced terrain metrics}
\usage{
calculate_advanced_terrain_metrics(
  elevation_raster,
  metrics = c("wetness_index", "curvature", "convergence"),
  region_boundary = NULL
)
}
\arguments{
\item{elevation_raster}{Digital elevation model}

\item{metrics}{Vector of metrics to calculate}

\item{region_boundary}{Optional region boundary}
}
\value{
List of terrain metric rasters
}
\description{
Calculate advanced terrain metrics from DEM including curvature,
wetness index, and stream power index.
}
\examples{
\dontrun{
# These examples require external data files not included with the package
# Calculate advanced terrain metrics
terrain_metrics <- calculate_advanced_terrain_metrics(
  elevation_raster = "dem.tif",
  metrics = c("wetness_index", "curvature", "convergence"),
  region_boundary = "watershed.shp"
)
}

}
