% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-water-indices.R
\name{calculate_water_index}
\alias{calculate_water_index}
\title{Calculate water indices including both NDWI variants}
\usage{
calculate_water_index(
  green,
  nir,
  swir1 = NULL,
  index_type = "NDWI",
  clamp_range = NULL,
  mask_invalid = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{green}{Green band SpatRaster or file path}

\item{nir}{NIR band SpatRaster or file path}

\item{swir1}{SWIR1 band SpatRaster or file path (for MNDWI, NDMI)}

\item{index_type}{Index type: "NDWI", "MNDWI", "NDMI", "MSI", "NDII", "WI", "SRWI", "LSWI"}

\item{clamp_range}{Optional range to clamp output values}

\item{mask_invalid}{Mask invalid/extreme values}

\item{verbose}{Print progress messages}
}
\value{
SpatRaster of water index
}
\description{
Calculate various water indices including NDWI (McFeeters 1996),
MNDWI (Xu 2006), and NDMI (Gao 1996) for water body detection and moisture content.
Updated formulas based on latest research and satellite missions (2024).
}
\details{
Available water indices with their specific applications:
\subsection{Primary Water Detection Indices:}{

\itemize{
\item \strong{NDWI} (McFeeters 1996): (Green - NIR) / (Green + NIR)
- \strong{Use}: Open water body detection, flood mapping
- \strong{Range}: Values from -1 to 1, water bodies typically > 0.3
- \strong{Pros}: Simple, effective for clear water
- \strong{Cons}: Sensitive to built-up areas, can overestimate water

\item \strong{MNDWI} (Xu 2006): (Green - SWIR1) / (Green + SWIR1)
- \strong{Use}: Enhanced water detection, urban water bodies
- \strong{Range}: Values from -1 to 1, water bodies typically > 0.5
- \strong{Pros}: Better separation of water from built-up areas
- \strong{Cons}: Requires SWIR band, less effective with turbid water
}
}

\subsection{Vegetation Moisture Indices:}{

\itemize{
\item \strong{NDMI} (Gao 1996): (NIR - SWIR1) / (NIR + SWIR1)
- \strong{Use}: Vegetation water content, drought monitoring
- \strong{Range}: Values from -1 to 1, higher values = more water content
- \strong{Application}: Agriculture, forest fire risk assessment

\item \strong{MSI}: SWIR1 / NIR - Moisture Stress Index
- \strong{Use}: Plant water stress detection
- \strong{Range}: \code{[0, 5+]}, lower values = higher moisture

\item \strong{NDII}: (NIR - SWIR1) / (NIR + SWIR1) - Same as NDMI
- \strong{Use}: Alternative name for NDMI, vegetation moisture
}
}

\subsection{Specialized Water Indices:}{

\itemize{
\item \strong{WI}: NIR / SWIR1 - Water Index (simple ratio)
\item \strong{SRWI}: NIR / SWIR1 - Simple Ratio Water Index
\item \strong{LSWI}: (NIR - SWIR1) / (NIR + SWIR1) - Land Surface Water Index
}
}

\subsection{Band Requirements by Satellite:}{
\itemize{
\item \strong{Landsat 8/9}: Green=Band 3, NIR=Band 5, SWIR1=Band 6
\item \strong{Sentinel-2}: Green=Band 3, NIR=Band 8, SWIR1=Band 11
\item \strong{MODIS}: Green=Band 4, NIR=Band 2, SWIR1=Band 6
}
}
}
\examples{
\dontrun{
# These examples require external data files not included with the package
# Original NDWI for water body detection
ndwi <- calculate_water_index(green_band, nir_band, index_type = "NDWI")

# Modified NDWI for enhanced water detection (requires SWIR1)
mndwi <- calculate_water_index(green_band, nir_band, swir1_band, index_type = "MNDWI")

# NDMI for vegetation moisture monitoring
ndmi <- calculate_water_index(green_band, nir_band, swir1_band, index_type = "NDMI")

# With quality control
water_index <- calculate_water_index(
  green = "green.tif",
  nir = "nir.tif",
  swir1 = "swir1.tif",
  index_type = "MNDWI",
  clamp_range = c(-1, 1),
  mask_invalid = TRUE,
  verbose = TRUE
)
}

}
