% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/15-helpers.R
\name{preview_geocoding}
\alias{preview_geocoding}
\title{Preview geographic entity detection}
\usage{
preview_geocoding(data, show_sample = TRUE, n_sample = 5)
}
\arguments{
\item{data}{Data frame to analyze}

\item{show_sample}{Show sample values (default: TRUE)}

\item{n_sample}{Number of sample values to show (default: 5)}
}
\value{
List with detection results
}
\description{
Test what geographic entities will be detected in your data without
actually performing the geocoding. Useful for debugging and verification.
}
\examples{
\dontrun{
# Check what will be detected
my_data <- data.frame(
  HUC_8 = c("04100009", "04100012"),
  State = c("Ohio", "PA"),
  value = c(100, 200)
)

preview_geocoding(my_data)
}

}
