% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggbrain_panel.R
\name{ggbrain_panel}
\alias{ggbrain_panel}
\title{R6 class for a single panel of a ggbrain image}
\value{
a \code{ggbrain_panel} R6 class with fields related to a panel on the \code{ggbrain} plot
}
\description{
R6 class for a single panel of a ggbrain image

R6 class for a single panel of a ggbrain image
}
\details{
Note that this class is exported only for power users and rarely needs to be called directly
in typical use of the package. Instead, look at \code{slices()}.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{gg}}{The ggplot object that contains the panel}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ggbrain_panel-new}{\code{ggbrain_panel$new()}}
\item \href{#method-ggbrain_panel-reset_limits}{\code{ggbrain_panel$reset_limits()}}
\item \href{#method-ggbrain_panel-plot}{\code{ggbrain_panel$plot()}}
\item \href{#method-ggbrain_panel-add_to_gg}{\code{ggbrain_panel$add_to_gg()}}
\item \href{#method-ggbrain_panel-add_layer}{\code{ggbrain_panel$add_layer()}}
\item \href{#method-ggbrain_panel-remove_layers}{\code{ggbrain_panel$remove_layers()}}
\item \href{#method-ggbrain_panel-get_data}{\code{ggbrain_panel$get_data()}}
\item \href{#method-ggbrain_panel-get_layer_names}{\code{ggbrain_panel$get_layer_names()}}
\item \href{#method-ggbrain_panel-get_layers}{\code{ggbrain_panel$get_layers()}}
\item \href{#method-ggbrain_panel-set_layer_order}{\code{ggbrain_panel$set_layer_order()}}
\item \href{#method-ggbrain_panel-clone}{\code{ggbrain_panel$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_panel-new"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_panel-new}{}}}
\subsection{Method \code{new()}}{
create a new ggbrain_panel object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_panel$new(
  layers = NULL,
  title = NULL,
  bg_color = NULL,
  text_color = NULL,
  border_color = NULL,
  border_size = NULL,
  xlab = NULL,
  ylab = NULL,
  theme_custom = NULL,
  annotations = NULL,
  region_labels = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{layers}}{a list of ggbrain_layer objects to form the panel}

\item{\code{title}}{a title for the panel added to the ggplot object using ggtitle()}

\item{\code{bg_color}}{the color used for the background of the plot. Default: 'gray10' (nearly black)}

\item{\code{text_color}}{the color used for text displayed on the plot. Default: 'white'.}

\item{\code{border_color}}{the color used for drawing a border around on the plot. Default: 'gray50'
(though borders are not drawn by default).}

\item{\code{border_size}}{the size of the border line drawn around the panel. Default: NULL. If this value is
greater than zero, a border of this size and with color \code{border_color} will be drawn around the panel}

\item{\code{xlab}}{The label to place on x axis. Default is NULL.}

\item{\code{ylab}}{The label to place on y axis. Default is NULL.}

\item{\code{theme_custom}}{Any custom theme() settings to be added to the plot}

\item{\code{annotations}}{a data.frame containing all annotations to be added to this plot. Each row is cleaned up
and passed to ggplot2::annotate()}

\item{\code{region_labels}}{a list of ggbrain_label objects with data for plotting region labels on this panel}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_panel-reset_limits"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_panel-reset_limits}{}}}
\subsection{Method \code{reset_limits()}}{
Reset the scale limits for the specified layers
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_panel$reset_limits(layer_names)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{layer_names}}{not implemented yet}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_panel-plot"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_panel-plot}{}}}
\subsection{Method \code{plot()}}{
plot the panel
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_panel$plot(use_global_limits = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_global_limits}}{Not implemented at present}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_panel-add_to_gg"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_panel-add_to_gg}{}}}
\subsection{Method \code{add_to_gg()}}{
add one or more custom ggplot settings to the panel
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_panel$add_to_gg(list_args)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{list_args}}{A list containing elements to add to the ggplot object}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Note that passing in an expression such as theme_bw() + ggtitle("hello")
will not work because it creates an object that cannot be added sequentially to
the ggplot. As noted in ggplot2's documentation (https://ggplot2.tidyverse.org/reference/gg-add.html),
to programmatically add elements to a ggplot, pass in a list where each element is added sequentially
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_panel-add_layer"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_panel-add_layer}{}}}
\subsection{Method \code{add_layer()}}{
adds a ggplot_layer object to the panel
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_panel$add_layer(layer_obj)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{layer_obj}}{a ggbrain_layer object to add to the panel}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_panel-remove_layers"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_panel-remove_layers}{}}}
\subsection{Method \code{remove_layers()}}{
removes one or more layers by name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_panel$remove_layers(layer_names)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{layer_names}}{a character string of the layers to remove from the panel}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_panel-get_data"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_panel-get_data}{}}}
\subsection{Method \code{get_data()}}{
returns the data for all layers in the object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_panel$get_data()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_panel-get_layer_names"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_panel-get_layer_names}{}}}
\subsection{Method \code{get_layer_names()}}{
returns the names of the layers in this panel, ordered from bottom to top
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_panel$get_layer_names()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_panel-get_layers"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_panel-get_layers}{}}}
\subsection{Method \code{get_layers()}}{
returns a list of ggbrain_layer objects that comprise this panel
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_panel$get_layers()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_panel-set_layer_order"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_panel-set_layer_order}{}}}
\subsection{Method \code{set_layer_order()}}{
sets the order of layers from bottom to top based on the layer names provided
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_panel$set_layer_order(ordered_names = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ordered_names}}{the names of the layers in the desired order from bottom to top. All layer names
must be provided, not just a subset}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_panel-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_panel-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_panel$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
