% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggbrain_plot.R
\name{ggbrain_plot}
\alias{ggbrain_plot}
\title{An R6 class for constructing a ggbrain plot from a ggbrain_slices object}
\value{
a \code{ggbrain_plot} R6 class containing fields related to a ggbrain plot object
}
\description{
An R6 class for constructing a ggbrain plot from a ggbrain_slices object

An R6 class for constructing a ggbrain plot from a ggbrain_slices object
}
\details{
Note that this class is exported only for power users and rarely needs to be called directly
in typical use of the package. Instead, look at \code{ggbrain()}.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{slices}}{a ggbrain_slices object containing all slice data for this plot}

\item{\code{layers}}{a list of ggbrain_layer objects for this plot. Note that in assignment, the
input can be a list of ggbrain_layer objects, or a list of lists where each inner element
specifies the settings for that layer. Example: \verb{list(list(name='hello', fill_scale=scale_fill_distiller())}}

\item{\code{annotations}}{a list of annotations to be added to this plot}

\item{\code{region_labels}}{a list of region_labels to be added to this plot}

\item{\code{panel_settings}}{a list of panel settings (aesthetics) to be added to this plot}

\item{\code{title}}{overall plot title, added to composite plot by \code{patchwork::plot_annotation()}}

\item{\code{bg_color}}{background color of plot}

\item{\code{text_color}}{the color of text use across panels (can be overridden by panel settings)}

\item{\code{base_size}}{the base size of text used in ggplot theming}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ggbrain_plot-new}{\code{ggbrain_plot$new()}}
\item \href{#method-ggbrain_plot-add_layers}{\code{ggbrain_plot$add_layers()}}
\item \href{#method-ggbrain_plot-reset_layers}{\code{ggbrain_plot$reset_layers()}}
\item \href{#method-ggbrain_plot-generate_plot}{\code{ggbrain_plot$generate_plot()}}
\item \href{#method-ggbrain_plot-plot}{\code{ggbrain_plot$plot()}}
\item \href{#method-ggbrain_plot-clone}{\code{ggbrain_plot$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_plot-new"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_plot-new}{}}}
\subsection{Method \code{new()}}{
instantiate a new instance of a ggbrain_plot object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_plot$new(
  title = NULL,
  bg_color = NULL,
  text_color = NULL,
  base_size = NULL,
  slice_data = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{title}}{overall plot title}

\item{\code{bg_color}}{background color of plot}

\item{\code{text_color}}{text color of plot}

\item{\code{base_size}}{base size of text used in ggplot theming}

\item{\code{slice_data}}{a ggbrain_slices object generated by ggbrain_images$get_slices()}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_plot-add_layers"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_plot-add_layers}{}}}
\subsection{Method \code{add_layers()}}{
adds one or more ggbrain_layer objects to this plot
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_plot$add_layers(layers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{layers}}{a list of ggbrain_layer objects (can also be a list that just specifies names, definitions, etc.)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_plot-reset_layers"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_plot-reset_layers}{}}}
\subsection{Method \code{reset_layers()}}{
removes all existing layers from this ggbrain_plot object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_plot$reset_layers()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_plot-generate_plot"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_plot-generate_plot}{}}}
\subsection{Method \code{generate_plot()}}{
generate the plot
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_plot$generate_plot(layers = NULL, slice_indices = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{layers}}{a list of layers to be displayed on each panel, the order of which yields the
bottom-to-to drawing order within ggplot2. Each element of \code{layers} should be a list
that follows the approximate structure of the ggbrain_layer class, minimally including
the layer \code{name}, which is used to lookup data of images or contrasts within the
slice_data object. If NULL, all layers in the slices object will be plotted. If only
a character string is passed, then those layers will be plotted with default scales.}

\item{\code{slice_indices}}{An optional subset of slice indices to display from the stored slice data}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
In addition to \code{name}, the elements of a layer can include
\code{fill_scale} a ggplot2 scale object for coloring the layer. Should be a scale_fill_* object.
\code{limits} the numeric limits to use for the color scale of this layer
\code{breaks} the scale breaks to use for the color scale of this layer
\code{show_legend} if FALSE, the color scale will not appear in the legend
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_plot-plot"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_plot-plot}{}}}
\subsection{Method \code{plot()}}{
return a plot of all panels as a patchwork object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_plot$plot(guides = "collect", ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{guides}}{Passes through to patchwork::plot_layout to control how legends are combined across plots. The default
is "collect", which collects legends within a given nesting level (removes duplicates).}

\item{\code{...}}{additional arguments. Not used currently}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_plot-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_plot-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_plot$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
