% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colors.R
\name{class_color}
\alias{class_color}
\title{color class}
\usage{
class_color(
  color = character(0),
  hue = NULL,
  saturation = NULL,
  brightness = NULL,
  alpha = NULL,
  id = character(0)
)
}
\arguments{
\item{color}{character (R color or hex code)}

\item{hue}{get or set the hue of a color (i.e., the h in the hsv model)}

\item{saturation}{get or set the saturation of a color (i.e., the s in the hsv model)}

\item{brightness}{get or set the brightness of a color (i.e., the v in the hsv model)}

\item{alpha}{get or set the transparency of a color}

\item{id}{character identifier}
}
\value{
class_color object
}
\description{
Useful for manipulating colors in R.
}
\section{Slots}{

\describe{
\item{\code{transparentize}}{function to return the color with a new transparency (i.e., alpha)}

\item{\code{lighten}}{function to return a lighter color}

\item{\code{darken}}{function to return a darker color}
}}

\examples{
mycolor <- class_color("blue")
mycolor
# Display html hexcode
c(mycolor)
# Set transparency
mycolor@transparentize(.5)
# Lighten color
mycolor@lighten(.5)
# Darken color
mycolor@darken(.5)
}
