% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-continuous-distribution.R
\name{scale_continuous_distribution}
\alias{scale_continuous_distribution}
\alias{scale_x_continuous_distribution}
\alias{scale_y_continuous_distribution}
\title{Position scales for continuous distributions}
\usage{
scale_x_continuous_distribution(
  name = waiver(),
  breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  expand = waiver(),
  oob = oob_keep,
  guide = waiver(),
  position = "bottom",
  sec.axis = waiver(),
  ...
)

scale_y_continuous_distribution(
  name = waiver(),
  breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  expand = waiver(),
  oob = scales::oob_keep,
  guide = waiver(),
  position = "left",
  sec.axis = waiver(),
  ...
)
}
\arguments{
\item{name}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}

\item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks computed by the
\link[scales:new_transform]{transformation object}
\item A numeric vector of positions
\item A function that takes the limits as input and returns breaks
as output (e.g., a function returned by \code{\link[scales:breaks_extended]{scales::extended_breaks()}}).
Note that for position scales, limits are provided after scale expansion.
Also accepts rlang \link[rlang:as_function]{lambda} function notation.
}}

\item{labels}{One of the options below. Please note that when \code{labels} is a
vector, it is highly recommended to also set the \code{breaks} argument as a
vector to protect against unintended mismatches.
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item An expression vector (must be the same length as breaks). See ?plotmath for details.
\item A function that takes the breaks as input and returns labels
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}

\item{limits}{One of:
\itemize{
\item \code{NULL} to use the default scale range
\item A numeric vector of length two providing limits of the scale.
Use \code{NA} to refer to the existing minimum or maximum
\item A function that accepts the existing (automatic) limits and returns
new limits. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
Note that setting limits on positional scales will \strong{remove} data outside of the limits.
If the purpose is to zoom, use the limit argument in the coordinate system
(see \code{\link[ggplot2:coord_cartesian]{coord_cartesian()}}).
}}

\item{expand}{For position scales, a vector of range expansion constants used to add some
padding around the data to ensure that they are placed some distance
away from the axes. Use the convenience function \code{\link[ggplot2:expansion]{expansion()}}
to generate the values for the \code{expand} argument. The defaults are to
expand the scale by 5\% on each side for continuous variables, and by
0.6 units on each side for discrete variables.}

\item{oob}{One of:
\itemize{
\item Function that handles limits outside of the scale limits
(out of bounds). Also accepts rlang \link[rlang:as_function]{lambda}
function notation.
\item The default (\code{\link[scales:oob]{scales::censor()}}) replaces out of
bounds values with \code{NA}.
\item \code{\link[scales:oob]{scales::squish()}} for squishing out of bounds values into range.
\item \code{\link[scales:oob]{scales::squish_infinite()}} for squishing infinite values into range.
}}

\item{guide}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}

\item{position}{For position scales, The position of the axis.
\code{left} or \code{right} for y axes, \code{top} or \code{bottom} for x axes.}

\item{sec.axis}{\code{\link[ggplot2:sec_axis]{sec_axis()}} is used to specify a secondary axis.}

\item{...}{Other arguments passed on to \verb{scale_(x|y)_continuous()}}
}
\value{
A ggplot2 scale
}
\description{
These scales allow for distributions to be passed to the x and y position by mapping distribution objects
to continuous aesthetics.
These scale can be used similarly to the scale_*_continuous functions, but they do not
accept transformations.
If you want to transform your scale, you should apply a transformation through the coord_* functions,
as they are applied after the stat, so the existing ggplot infastructure can be used.
For example, if you would like a log transformation of the x axis, plot + coord_transform(x = "log")
would work fine.
}
\examples{
library(ggplot2)
library(distributional)
set.seed(1997)
point_data <- data.frame(xvar = c(dist_uniform(2,3),
                                  dist_normal(3,2),
                                  dist_exponential(3)),
                         yvar = c(dist_gamma(2,1), 
                                  dist_sample(x = list(rnorm(100, 5, 1))), 
                                  dist_exponential(1)))
ggplot(data = point_data) + 
  geom_point_sample(aes(x=xvar, y=yvar)) +
  scale_x_continuous_distribution(name="Hello, I am a random variable", limits = c(-5, 10)) +
  scale_y_continuous_distribution(name="I am also a random variable")

}
