% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bounder.R
\name{bounder_cooke}
\alias{bounder_cooke}
\title{Estimate bounds of a distribution using Cooke's method}
\usage{
bounder_cooke(x)
}
\arguments{
\item{x}{<\link{numeric}> Sample to estimate the bounds of.}
}
\value{
A length-2 numeric vector giving an estimate of the minimum and maximum bounds
of the distribution that \code{x} came from.
}
\description{
Estimate the bounds of the distribution a sample came from using Cooke's method.
Use with the \code{bounder} argument to \code{\link[=density_bounded]{density_bounded()}}.

Supports \link[=auto_partial]{automatic partial function application} with
\link[=waiver]{waived arguments}.
}
\details{
Estimate the bounds of a distribution using the method from Cooke (1979);
i.e. method 2.3 from Loh (1984). These bounds are:

\deqn{\left[\begin{array}{l}
2X_{(1)} - \sum_{i = 1}^n \left[\left(1 - \frac{i - 1}{n}\right)^n -
  \left(1 - \frac{i}{n}\right)^n \right] X_{(i)}\\
2X_{(n)} - \sum_{i = 1}^n \left[\left(1 - \frac{n - i}{n}\right)^n -
  \left(1 - \frac{n + 1 - i}{n} \right)^n\right] X_{(i)}
\end{array}\right]}

Where \eqn{X_{(i)}} is the \eqn{i}th order statistic of \code{x} (i.e. its
\eqn{i}th-smallest value).
}
\references{
Cooke, P. (1979). Statistical inference for bounds of random variables.
\emph{Biometrika} 66(2), 367--374. \doi{10.1093/biomet/66.2.367}.

Loh, W. Y. (1984). Estimating an endpoint of a distribution with resampling
methods. \emph{The Annals of Statistics} 12(4), 1543--1550. \doi{10.1214/aos/1176346811}
}
\seealso{
The \code{bounder} argument to \code{\link[=density_bounded]{density_bounded()}}.

Other bounds estimators: 
\code{\link{bounder_cdf}()},
\code{\link{bounder_range}()}
}
\concept{bounds estimators}
