% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subguide.R
\name{subguide_axis}
\alias{subguide_axis}
\alias{subguide_inside}
\alias{subguide_outside}
\alias{subguide_integer}
\alias{subguide_count}
\alias{subguide_slab}
\alias{subguide_dots}
\alias{subguide_spike}
\title{Axis sub-guide for thickness scales}
\usage{
subguide_axis(
  values,
  title = NULL,
  breaks = waiver(),
  labels = waiver(),
  position = 0,
  just = 0,
  label_side = "topright",
  orientation = "horizontal",
  theme = theme_get()
)

subguide_inside(..., label_side = "inside")

subguide_outside(..., label_side = "outside", just = 1)

subguide_integer(..., breaks = scales::breaks_extended(Q = c(1, 5, 2, 4, 3)))

subguide_count(..., breaks = scales::breaks_width(1))

subguide_slab(values, ...)

subguide_dots(values, ...)

subguide_spike(values, ...)
}
\arguments{
\item{values}{<\link{numeric}> Values used to construct the scale used for this guide.
Typically provided automatically by \code{\link[=geom_slabinterval]{geom_slabinterval()}}.}

\item{title}{<\link[=character]{string}> The title of the scale shown on the sub-guide's axis.}

\item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks computed by the
\link[scales:new_transform]{transformation object}
\item A numeric vector of positions
\item A function that takes the limits as input and returns breaks
as output (e.g., a function returned by \code{\link[scales:breaks_extended]{scales::extended_breaks()}}).
Note that for position scales, limits are provided after scale expansion.
Also accepts rlang \link[rlang:as_function]{lambda} function notation.
}}

\item{labels}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item An expression vector (must be the same length as breaks). See ?plotmath for details.
\item A function that takes the breaks as input and returns labels
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}

\item{position}{<scalar \link{numeric}> Value between \code{0} and \code{1} giving the position of the
guide relative to the axis: \code{0} causes the sub-guide to be drawn on the
left or bottom depending on if \code{orientation} is \code{"horizontal"} or \code{"vertical"},
and \code{1} causes the sub-guide to be drawn on the top or right depending on
if \code{orientation} is \code{"horizontal"} or \code{"vertical"}. May also be a string
indicating the position: \code{"top"}, \code{"right"}, \code{"bottom"}, \code{"left"},
\code{"topright"}, \code{"topleft"}, \code{"bottomright"}, or \code{"bottomleft"}.}

\item{just}{<scalar \link{numeric}> Value between \code{0} and \code{1} giving the justification of the
guide relative to its position: 0 means aligned towards the inside of the
axis edge, 1 means aligned towards the outside of the axis edge.}

\item{label_side}{<\link[=character]{string}> Which side of the axis to draw the ticks and labels on.
\code{"topright"}, \code{"top"}, and \code{"right"} are synonyms which cause the labels
to be drawn on the top or the right depending on if \code{orientation} is
\code{"horizontal"} or \code{"vertical"}. \code{"bottomleft"}, \code{"bottom"}, and \code{"left"}
are synonyms which cause the labels to be drawn on the bottom or the left
depending on if \code{orientation} is \code{"horizontal"} or \code{"vertical"}.
\code{"topleft"} causes the labels to be drawn on the top or the left, and
\code{"bottomright"} causes the labels to be drawn on the bottom or the right.
\code{"inside"} causes the labels to be drawn on the side closest to the inside
of the chart, depending on \code{position}, and \code{"outside"} on the side closest
to the outside of the chart.}

\item{orientation}{<\link[=character]{string}> Orientation of the geometry this sub-guide is for. One
of \code{"horizontal"} (\code{"y"}) or \code{"vertical"} (\code{"x"}). See the \code{orientation}
parameter to \code{\link[=geom_slabinterval]{geom_slabinterval()}}.}

\item{theme}{<\link[ggplot2:theme]{theme}> Theme used to determine the style that the
sub-guide elements are drawn in. The title label is drawn using the
\code{"axis.title.x"} or \code{"axis.title.y"} theme setting, and the axis line,
ticks, and tick labels are drawn using \code{\link[ggplot2:guide_axis]{guide_axis()}}, so the same theme
settings that normally apply to axis guides will be followed.}

\item{...}{Arguments passed to other functions, typically back to
\code{subguide_axis()} itself.}
}
\description{
This is a sub-guide intended for annotating the \code{thickness} and dot-count
subscales in \pkg{ggdist}. It can be used with the \code{subguide} parameter of
\code{\link[=geom_slabinterval]{geom_slabinterval()}} and \code{\link[=geom_dotsinterval]{geom_dotsinterval()}}.

Supports \link[=auto_partial]{automatic partial function application} with
\link[=waiver]{waived arguments}.
}
\details{
\code{\link[=subguide_inside]{subguide_inside()}} is a shortcut for drawing labels inside of the chart
region.

\code{\link[=subguide_outside]{subguide_outside()}} is a shortcut for drawing labels outside of the chart
region.

\code{\link[=subguide_integer]{subguide_integer()}} only draws breaks that are integer values, useful for
labeling counts in \code{\link[=geom_dots]{geom_dots()}}.

\code{\link[=subguide_count]{subguide_count()}} is a shortcut for drawing labels where \emph{every} whole number
is labeled, useful for labeling counts in \code{\link[=geom_dots]{geom_dots()}}. If your max count is
large, \code{\link[=subguide_integer]{subguide_integer()}} may be better.

\code{\link[=subguide_slab]{subguide_slab()}}, \code{\link[=subguide_dots]{subguide_dots()}}, and \code{\link[=subguide_spike]{subguide_spike()}} are aliases
for \code{\link[=subguide_none]{subguide_none()}} that allow you to change the default subguide used
for the \code{\link[=geom_slabinterval]{geom_slabinterval()}}, \code{\link[=geom_dotsinterval]{geom_dotsinterval()}}, and \code{\link[=geom_spike]{geom_spike()}}
families. If you overwrite these in the global environment, you can set
the corresponding default subguide. For example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{subguide_slab = ggdist::subguide_inside(position = "right")
}\if{html}{\out{</div>}}

This will cause \code{\link[=geom_slabinterval]{geom_slabinterval()}}s to default to having a guide on the
right side of the geom.
}
\examples{
library(ggplot2)
library(distributional)

df = data.frame(d = dist_normal(2:3, 2:3), g = c("a", "b"))

# subguides allow you to label thickness axes
ggplot(df, aes(xdist = d, y = g)) +
  stat_slabinterval(subguide = "inside")

# they respect normalization and use of scale_thickness_shared()
ggplot(df, aes(xdist = d, y = g)) +
  stat_slabinterval(subguide = "inside", normalize = "groups")

# they can also be positioned outside the plot area, though
# this typically requires manually adjusting plot margins
ggplot(df, aes(xdist = d, y = g)) +
  stat_slabinterval(subguide = subguide_outside(title = "density", position = "right")) +
  theme(plot.margin = margin(5.5, 50, 5.5, 5.5))

# any of the subguide types will also work to indicate bin counts in
# geom_dots(); subguide_integer() and subguide_count() can be useful for
# dotplots as they only label integers / whole numbers:
df = data.frame(d = dist_gamma(2:3, 2:3), g = c("a", "b"))
ggplot(df, aes(xdist = d, y = g)) +
  stat_dots(subguide = subguide_count(label_side = "left", title = "count")) +
  scale_y_discrete(expand = expansion(add = 0.1)) +
  scale_x_continuous(expand = expansion(add = 0.5))

}
\seealso{
The \link{thickness} datatype.

The \code{thickness} aesthetic of \code{\link[=geom_slabinterval]{geom_slabinterval()}}.

\code{\link[=scale_thickness_shared]{scale_thickness_shared()}}, for setting a \code{thickness} scale across
all geometries using the \code{thickness} aesthetic.

\code{\link[=subscale_thickness]{subscale_thickness()}}, for setting a \code{thickness} sub-scale within
a single \code{\link[=geom_slabinterval]{geom_slabinterval()}}.

Other sub-guides: 
\code{\link{subguide_none}()}
}
\concept{sub-guides}
