% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lib.R
\name{fd_load}
\alias{fd_load}
\title{Load the ggfigdone database}
\usage{
fd_load(dir, auto_database_upgrade = TRUE, set_default = TRUE)
}
\arguments{
\item{dir}{A character string representing the directory path.}

\item{auto_database_upgrade}{A logical value. If TRUE, the function will automatically upgrade the database to the latest version.
If FALSE, you need to manually save the data using the \code{\link[ggfigdone]{fd_save}} function.}

\item{set_default}{A logical value. If TRUE, the function will set the database as the default database.}
}
\value{
An object of class \code{fdObj}.
}
\description{
This function loads the ggfigdone database from the disk.
}
\examples{
library(ggplot2)
## create ggfigdone database in a temporary directory
db_dir = file.path(tempdir(), "fd_load")
fd_init(db_dir, rm_exist = TRUE)

## Load the ggfigdone database
fd_load(db_dir)

}
