% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_terminator.R
\name{geom_terminator}
\alias{geom_terminator}
\title{A 'ggplot2' geom to draw transcription terminators}
\usage{
geom_terminator(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = FALSE,
  terminator_height = unit(3, "mm"),
  terminator_width = unit(3, "mm"),
  ...
)
}
\arguments{
\item{mapping, data, stat, position, na.rm, show.legend, inherit.aes, ...}{As
standard for ggplot2. inherit.aes is set to FALSE by default, as terminators
are not likely to share any plot aesthetics other than y.}

\item{terminator_height}{\code{grid::unit()} object giving the height of the
vertical 'pillar' of the terminator glyph above the molecule line. Can be
set as a negative value to draw terminators below the line. Defaults to 3
mm.}

\item{terminator_width}{\code{grid::unit()} object giving the width of the
horizontal 'beam' of the terminator glyph. Defaults to 3 mm.}
}
\description{
\code{geom_terminator()} draws a 'T-shaped' glyph representing the position of a
transcription terminator.
}
\section{Aesthetics}{

\itemize{
\item x (required; position of the terminator)
\item y (required; molecule)
\item alpha
\item color
\item linetype
\item linewidth (the former size aesthetic has been deprecated and will be
removed in future versions)
}
}

\examples{

ggplot2::ggplot(example_genes, ggplot2::aes(xmin = start, xmax = end,
                                            y = molecule, fill = gene)) +
  geom_gene_arrow() +
  geom_terminator(data = example_terminators, ggplot2::aes(x = position, y = molecule)) +
  ggplot2::facet_wrap(~ molecule, scales = "free")

}
\seealso{
\code{\link[=geom_terminator_label]{geom_terminator_label()}}, \code{\link[=geom_feature]{geom_feature()}}
}
