% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strip_nested.R
\name{strip_nested}
\alias{strip_nested}
\title{Nested strips}
\usage{
strip_nested(
  clip = "inherit",
  size = "constant",
  bleed = FALSE,
  text_x = NULL,
  text_y = NULL,
  background_x = NULL,
  background_y = NULL,
  by_layer_x = FALSE,
  by_layer_y = FALSE
)
}
\arguments{
\item{clip}{A \code{character(1)} that controls whether text labels are clipped to
the background boxes. Can be either \code{"inherit"} (default), \code{"on"} or
\code{"off"}.}

\item{size}{A \code{character(1)} stating that the strip margins in different
layers remain \code{"constant"} or are \code{"variable"}.}

\item{bleed}{A \code{logical(1)} indicating whether merging of lower-layer
variables is allowed when the higher-layer variables are separate. See
details.}

\item{text_x, text_y}{A \code{list()} with
\code{\link[ggplot2:element]{element_text()}} elements. See the details
section in \code{\link[=strip_themed]{strip_themed()}}.}

\item{background_x, background_y}{A \code{list()} with
\code{\link[ggplot2:element]{element_rect()}} elements. See the details
section in \code{\link[=strip_themed]{strip_themed()}}.}

\item{by_layer_x, by_layer_y}{A \code{logical(1)} that when \code{TRUE}, maps the
different elements to different layers of the strip. When \code{FALSE}, maps the
different elements to individual strips, possibly repeating the elements to
match the number of strips through \code{rep_len()}.}
}
\value{
A \code{StripNested} ggproto object that can be given as an argument to
facets in ggh4x.
}
\description{
This strip style groups strips on the same layer that share a label. It is
the default strip for \code{\link[=facet_nested]{facet_nested()}} and
\code{\link[=facet_nested_wrap]{facet_nested_wrap()}}.
}
\details{
The display order is always such that the outermost
variable is placed the furthest away from the panels. Strips are
automatically grouped when they span a nested variable.

The \code{bleed} argument controls whether lower-layer strips are allowed
to be merged when higher-layer strips are different, i.e. they can bleed
over hierarchies. Suppose the \code{strip_vanilla()} behaviour would be the
following for strips:

\verb{[_1_][_2_][_2_]} \cr \verb{[_3_][_3_][_4_]}

In such case, the default \code{bleed = FALSE} argument would result in the
following:

\verb{[_1_][___2____]} \cr \verb{[_3_][_3_][_4_]}

Whereas \code{bleed = TRUE} would allow the following:

\verb{[_1_][___2____]} \cr \verb{[___3____][_4_]}
}
\examples{
# A standard plot
p <- ggplot(mpg, aes(displ, hwy)) +
  geom_point()

# Combine the strips
p + facet_wrap2(vars(cyl, drv), strip = strip_nested())

# The facet_nested and facet_nested_wrap functions have nested strips
# automatically
p + facet_nested_wrap(vars(cyl, drv))

# Changing the bleed argument merges the "f" labels in the top-right
p + facet_wrap2(vars(cyl, drv), strip = strip_nested(bleed = TRUE))
}
\seealso{
Other strips: 
\code{\link{strip_split}()},
\code{\link{strip_tag}()},
\code{\link{strip_themed}()},
\code{\link{strip_vanilla}()}
}
\concept{strips}
