% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gghdx.R
\name{gghdx}
\alias{gghdx}
\alias{gghdx_reset}
\title{Set HDX theme and aesthetics}
\usage{
gghdx(
  showtext = TRUE,
  base_size = 10,
  base_family = "Source Sans 3",
  horizontal = TRUE
)

gghdx_reset()
}
\arguments{
\item{showtext}{\code{logical} If \code{TRUE}, uses the showtext package to add
the Source Sans 3 font and runs \code{showtext_auto()} so all future plots
in this session will use the font.}

\item{base_size}{base font size, given in pts.}

\item{base_family}{base font family}

\item{horizontal}{\code{logical} Horizontal axis lines?}
}
\value{
No return value, run for the side effects described in Details.
}
\description{
\code{gghdx()} gives you the convenience of \code{theme_hdx()} without having to
explicitly call it for each plot. It also allows for setting the default
continuous and discrete scales to follow the HDX color scheme, including
default line and point colors and area fills. \code{gghdx_reset()} returns
all of these values back to the defaults.
}
\details{
\code{gghdx()} changes global settings for this R session. This includes updating
the ggplot2 default geometries using \code{ggplot2::update_geom_defaults()} and
setting global options to scale color and fill for ggplot2:
\itemize{
\item \code{options("ggplot2.discrete.fill")}
\item \code{options("ggplot2.discrete.colour")}
\item \code{options("ggplot2.continuous.fill")}
\item \code{options("ggplot2.continous.colour")}
}

The default discrete scale is \code{scale_..._hdx()} for both \code{fill} and \code{color}.
For continuous scales, the default is \code{scale_fill_gradient_hdx_mint()} for
fill and \code{scale_color_gradient_hdx_sapphire()} for color.

Once \code{gghdx()} is run, the easiest way to return to the default ggplot2
settings is to run \code{gghdx_reset()}. This will make changes by running:
\itemize{
\item \code{ggplot2::reset_theme_settings()}: resets the global theme to default.
\item For all of the options listed above, run \code{options("option") <- NULL}.
\item \code{showtext::showtext_end()} to stop using the showtext library if it was
activated.
\item Runs \code{ggplot2::update_geom_defaults()} for all geometries in
\code{\link[=ggplot2_geom_defaults]{ggplot2_geom_defaults()}}.
}

You can also simply restart your R session to return to the defaults.
}
\examples{

library(ggplot2)

p <- ggplot(mtcars) +
  geom_point(
    aes(
      x = mpg,
      y = hp
    )
  ) +
  labs(
    x = "Miles per gallon",
    y = "Horsepower",
    title = "Horsepower relative to miles per gallon"
  )

# see the plot using base aesthetics
p

# automatically use the gghdx theme and visuals
gghdx()
p

# get rid of the changes of gghdx
gghdx_reset()
p

}
\seealso{
\code{gghdx()} relies on the following functions:
\itemize{
\item \code{\link[=theme_hdx]{theme_hdx()}} as the default theme.
\item \code{\link[=load_source_sans_3]{load_source_sans_3()}} to load the font and activate showtext.
\item \code{\link[=hdx_geom_defaults]{hdx_geom_defaults()}} as the default geometries to set with
\code{ggplot2::update_geom_defaults()}.
\item \code{\link[=scale_color_hdx_discrete]{scale_color_hdx_discrete()}} and other family of functions to set standard
fill and color scales.
}
}
