% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-dodge-.R
\name{position_dodge_}
\alias{position_dodge_}
\alias{position_dodge2_}
\title{Dodge overlapping objects side-to-side}
\usage{
position_dodge_(width = NULL, preserve = c("total", "single"))

position_dodge2_(
  width = NULL,
  preserve = c("total", "single"),
  padding = 0.1,
  reverse = FALSE
)
}
\arguments{
\item{width}{Dodging width, when different to the width of the individual
elements. This is useful when you want to align narrow geoms with wider
geoms. See the examples.}

\item{preserve}{Should dodging preserve the \code{"total"} width of all elements
at a position, or the width of a \code{"single"} element?}

\item{padding}{Padding between elements at the same position. Elements are
shrunk by this proportion to allow space between them. Defaults to 0.1.}

\item{reverse}{If \code{TRUE}, will reverse the default stacking order.
This is useful if you're rotating both the plot and legend.}
}
\description{
Dodging preserves the vertical position of an geom while adjusting the horizontal position.
\code{position_dodge_()} dodges bars side by side but conditional on locations.
}
\details{
It is built based on \code{\link[ggplot2]{position_dodge}}, but used for multiple locations, such as
\code{geom_hist_()} or \code{geom_density_()}. Check examples to see the difference.
}
\section{Aesthetics}{


\code{position_dodge()} understands the following aesthetics. Required aesthetics are displayed in bold and defaults are displayed for optional aesthetics:
\tabular{rll}{
 • \tab \code{order} \tab → \code{NULL} \cr
}

Learn more about setting these aesthetics in \code{vignette("ggplot2-specs")}.




\code{position_dodge()} understands the following aesthetics. Required aesthetics are displayed in bold and defaults are displayed for optional aesthetics:
\tabular{rll}{
 • \tab \code{order} \tab → \code{NULL} \cr
}

Learn more about setting these aesthetics in \code{vignette("ggplot2-specs")}.

}

\examples{
if(require(dplyr)) {
p <- iris \%>\%
  tidyr::pivot_longer(cols = -Species,
                      names_to = "Outer sterile whorls",
                      values_to = "values") \%>\%
  ggplot(data,
         mapping = aes(x = `Outer sterile whorls`,
                       y = values,
                       fill = Species))

p + geom_hist_(position = position_dodge_())
}

\donttest{
# all bins are shifted on the left
p +
  geom_hist_(position = position_dodge())
}


}
\seealso{
See \code{\link{geom_hist_}} and \code{\link{geom_serialaxes_hist}} for more examples.

Other position adjustments for multiple locations:
\code{\link{position_identity_}},
\code{\link{position_stack_}}, \code{\link{position_fill_}}

Parent: \code{\link[ggplot2]{position_dodge}}
}
