% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggrasp.cluster.R
\name{ggrasp.cluster}
\alias{ggrasp.cluster}
\title{ggrasp.cluster}
\usage{
ggrasp.cluster(ggrasp.data, threshold, num.clusters, z.limit = 1,
  gmm.start = 2, gmm.max = 10, min.lambda = 0.005, run.type = "bgmm",
  left.dist = 1)
}
\arguments{
\item{ggrasp.data}{Required. If neither a threshold or a num.cluster is given, a mixed model of Gaussian distributions is used to estimate a threshold to use the cluster.}

\item{threshold}{The threshold used to cluster together all genomes within this distance.}

\item{num.clusters}{Create this number of clusters independent of the cluster.}

\item{z.limit}{All Gaussian distributions with means within this number of standard deviations will be reduced to only the larger distribution. Defaults to 1. Set to 0 to keep all non-overlapping distributions.}

\item{gmm.start}{Number of Gaussian distributions to start the examination. Must be at least 2 and not greater than the gmm.max.}

\item{gmm.max}{Maximum number of Gaussian distributions to examine. Has to be at least 2. 10 is the default}

\item{min.lambda}{All Gaussian distributions with lambda value (proportion of the total distribution) below this value are removed before calculating the threshold. Default is 0.005. Set to 0 to keep all.}

\item{run.type}{String giving the package to use to get the mixture model. Currently "bgmm" (default) and mixtools" are implemented.}

\item{left.dist}{Number giving the number Gaussian distribution model immediately to the left of the threshold used. 1 is the default. Only value between 1 and k-1 where k is the total number of number of Gaussian distributions.}
}
\value{
Returns a class GGRaSP variable with the clusters and medoids assigned. In cases where the Gaussian Mixture Model was used to estimate the cutoff threshold, the descriptive values of the different distributions is also stored
}
\description{
ggrasp.cluster() clusters the genomes in a GGRaSP class variable and assigns the most representative genome in each cluster after accounting for rank as a medoid.
}
\examples{
#The following data is from Chavda et al 2016 which phylotyped Enterobacter genomes
# Our example uses the data underpinning the tree shown in Figure 2
# Also included is a ranking file to prioritize closed Enterobactor genomes

#Loading the tree 
library(ggrasp);
tree.file <- system.file("extdata", "Enter.kSNP.tree", package="ggrasp")
rank.file.in <- system.file("extdata", "Enter.kSNP.ranks", package="ggrasp")
Enter.tree <- ggrasp.load(tree.file, file.format = "tree", rank.file = rank.file.in)

#Clustering the tree using a threshold estimated by Gaussian Mixture Models (GMMs)
\donttest{Enter.tree.cluster <- ggrasp.cluster(Enter.tree)}


#Use print to get a list of the medoids selected
\donttest{print(Enter.tree.cluster)}

#Re-clustering the tree using a threshold estimated by the GMMs but without the distribution
#cleaning (i.e. removing the overlapping and low count distributions)
\donttest{Enter.tree.reclust <- ggrasp.recluster(Enter.tree.cluster, z.limit=0, min.lambda = 0)}

#Use plot to examine the tree with the clusters highlighted and the medoid genome names on the edge
\donttest{plot(Enter.tree.cluster)}

#Additional printing and plotting options are availible with plot() and print(). 
#For more information refer to ?plot.ggrasp and ?print.ggrasp
}
