% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{movies_long}
\alias{movies_long}
\title{Movie information and user ratings from IMDB.com (long format).}
\format{
A data frame with 1,579 rows and 8 variables
\itemize{
\item title. Title of the movie.
\item year. Year of release.
\item budget. Total budget (if known) in US dollars
\item length. Length in minutes.
\item rating. Average IMDB user rating.
\item votes. Number of IMDB users who rated this movie.
\item mpaa. MPAA rating.
\item genre. Different genres of movies (action, animation, comedy, drama,
documentary, romance, short).
}
}
\source{
\url{https://CRAN.R-project.org/package=ggplot2movies}
}
\usage{
movies_long
}
\description{
Movie information and user ratings from IMDB.com (long format).
}
\details{
Modified dataset from \code{{ggplot2movies}} package.

The internet movie database (IMDB) is a website devoted
to collecting movie data supplied by studios and fans. It claims to be the
biggest movie database on the web and is run by amazon.
}
\examples{
dim(movies_long)
head(movies_long)
dplyr::glimpse(movies_long)
}
\keyword{datasets}
