% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_gradient_field.R
\name{geom_gradient_field}
\alias{geom_gradient_field}
\alias{stat_gradient_field}
\alias{geom_gradient_field2}
\alias{stat_gradient_field2}
\title{Create a Gradient Field Layer in ggplot2}
\usage{
geom_gradient_field(
  mapping = NULL,
  data = NULL,
  stat = StatStreamField,
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = TRUE,
  inherit.aes = TRUE,
  fun,
  xlim = NULL,
  ylim = NULL,
  n = 11,
  max_it = 1000,
  T = NULL,
  L = NULL,
  center = TRUE,
  type = "vector",
  normalize = TRUE,
  tail_point = FALSE,
  eval_point = FALSE,
  grid = NULL,
  lineend = "butt",
  linejoin = "round",
  linemitre = 10,
  arrow = grid::arrow(angle = 30, length = grid::unit(0.02, "npc"), type = "closed")
)

stat_gradient_field(
  mapping = NULL,
  data = NULL,
  geom = GeomStream,
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = TRUE,
  inherit.aes = TRUE,
  fun,
  xlim = NULL,
  ylim = NULL,
  n = 11,
  max_it = 1000,
  T = NULL,
  L = NULL,
  center = TRUE,
  type = "vector",
  normalize = TRUE,
  tail_point = FALSE,
  eval_point = FALSE,
  grid = NULL,
  lineend = "butt",
  linejoin = "round",
  linemitre = 10,
  arrow = grid::arrow(angle = 30, length = grid::unit(0.02, "npc"), type = "closed")
)

geom_gradient_field2(
  mapping = NULL,
  data = NULL,
  stat = StatStreamField,
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = TRUE,
  inherit.aes = TRUE,
  fun,
  xlim = NULL,
  ylim = NULL,
  n = 11,
  max_it = 1000,
  T = NULL,
  L = NULL,
  center = FALSE,
  type = "stream",
  normalize = TRUE,
  tail_point = TRUE,
  eval_point = FALSE,
  grid = NULL,
  lineend = "butt",
  linejoin = "round",
  linemitre = 10,
  arrow = NULL
)

stat_gradient_field2(
  mapping = NULL,
  data = NULL,
  geom = GeomStream,
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = TRUE,
  inherit.aes = TRUE,
  fun,
  xlim = NULL,
  ylim = NULL,
  n = 11,
  max_it = 1000,
  T = NULL,
  L = NULL,
  center = FALSE,
  type = "stream",
  normalize = TRUE,
  tail_point = TRUE,
  eval_point = FALSE,
  grid = NULL,
  lineend = "butt",
  linejoin = "round",
  linemitre = 10,
  arrow = NULL
)
}
\arguments{
\item{mapping}{A set of aesthetic mappings created by \code{ggplot2::aes()}.
Additional aesthetics such as \code{color}, \code{size}, \code{linetype}, and \code{alpha} can
be defined. In
\strong{geom_gradient_field} the default mapping includes \code{color = after_stat(norm)},
whereas in \strong{geom_gradient_field2} the default mapping includes \code{length = after_stat(norm)}.}

\item{data}{A data frame containing the input data.}

\item{stat}{The statistical transformation to use on the data for this layer.
Defaults to \link{StatStreamField}.}

\item{position}{Position adjustment, either as a string or the result of a
position adjustment function.}

\item{...}{Other arguments passed on to \code{grid::layer()}.}

\item{na.rm}{Logical. If \code{FALSE} (the default), missing values are removed
with a warning.}

\item{show.legend}{Logical. Should this layer be included in the legends?}

\item{inherit.aes}{Logical. If \code{FALSE}, overrides the default aesthetics
rather than combining with them.}

\item{fun}{A function that defines the scalar field. It should take a numeric
vector of length 2 (representing \eqn{(x, y)}) and return a single numeric
value. \strong{(Required)}}

\item{xlim}{Numeric vector of length two. Specifies the limits of the x-axis
domain. Defaults to \code{c(-1, 1)}.}

\item{ylim}{Numeric vector of length two. Specifies the limits of the y-axis
domain. Defaults to \code{c(-1, 1)}.}

\item{n}{Integer. Grid resolution specifying the number of seed points along
each axis. Higher values produce a denser gradient field. Defaults to \code{11}.}

\item{max_it}{Integer. Maximum number of integration steps allowed when
computing the gradient stream. Defaults to \code{1000}.}

\item{T}{Numeric. Time increment used for numerical integration when
\code{normalize} is FALSE. If not provided, it is computed automatically based
on grid spacing and the vector field’s magnitude.}

\item{L}{Numeric. Target length for the gradient vectors or streamlines. When
\code{normalize} is TRUE, computed vectors are scaled to have length L. If not
provided, L is computed automatically from the grid spacing.}

\item{center}{Logical. If \code{TRUE}, centers the seed points so that the
original (x, y) becomes the midpoint.}

\item{type}{Character. Specifies the type of field to compute: use \code{"stream"}
to generate integrated streamlines or \code{"vector"} for individual vector
segments. Defaults to \code{"stream"}.}

\item{normalize}{Logical. If \code{TRUE}, gradient vectors are normalized based on
grid spacing. Defaults to \code{TRUE}.}

\item{tail_point}{Logical. If \code{TRUE}, a point is drawn at the tail of each
gradient vector.}

\item{eval_point}{Logical. If \code{TRUE}, a point is drawn at the evaluation
point where the gradient was computed. Defaults to \code{FALSE}.}

\item{grid}{A data frame containing precomputed grid points for seed
placement. If \code{NULL} (default), a regular Cartesian grid is generated based
on \code{xlim}, \code{ylim}, and \code{n}.}

\item{lineend}{Line end style (round, butt, square).}

\item{linejoin}{Line join style (round, mitre, bevel).}

\item{linemitre}{Line mitre limit (number greater than 1).}

\item{arrow}{A \code{grid::arrow()} specification to add arrowheads to the
gradient vectors. In \strong{geom_gradient_field}, the default is a closed arrow
with a 30° angle and length \code{0.02} npc; in \code{geom_gradient_field2()}, the
default is \code{NULL}.}

\item{geom}{The geometric object used to render the streamline (only used in
\code{stat_stream()}; defaults to \link{GeomStream}).}
}
\value{
A ggplot2 layer that computes and plots a gradient field by
numerically differentiating a scalar field.
}
\description{
These functions provide convenient ggplot2 layers for drawing gradient fields
by computing the gradient of a scalar field. A user-defined function (\code{fun})
specifies the behavior of the scalar field by taking a numeric vector of
length 2 (representing \eqn{(x, y)}) and returning a single numeric value.
The underlying \link{StatStreamField} computes the gradient via numerical
differentiation (using \code{numDeriv::grad()}) and \link{GeomStream} renders the
resulting vectors.
}
\details{
Two variants are provided:
\itemize{
\item \strong{geom_gradient_field()} uses a default mapping that sets \code{color = after_stat(norm)}.
\item \strong{geom_gradient_field2()} uses a default mapping that sets \code{length = after_stat(norm)}
(with \code{color} unmapped by default).
}
}
\section{Aesthetics}{
 \code{geom_gradient_field()} and \code{geom_gradient_field2()}
understand the following aesthetics (required aesthetics are in \strong{bold}):
\itemize{
\item \strong{\code{x}}: The x-coordinate of the seed point.
\item \strong{\code{y}}: The y-coordinate of the seed point.
\item \strong{\code{color}}: In \strong{geom_gradient_field}, the color of the gradient vector.
In \strong{geom_gradient_field2}, color is not mapped by default.
\item \strong{\code{length}}: In \strong{geom_gradient_field2}, the computed vector norm.
\item \code{size}, \code{linetype}, \code{alpha}: Additional aesthetics to control appearance.
}
}

\section{Computed Variables}{


The following variables are computed internally by \link{StatStreamField} when
generating the gradient field from a scalar function:

\describe{
\item{norm}{The Euclidean norm of the gradient vector, calculated as
\eqn{\sqrt{fx^2 + fy^2}}. This value is used, by default, for mapping color or scaling
arrow lengths in the visualization.}

\item{avg_spd}{This variable may represent an average speed computed
from the gradient magnitude. In the default mapping for \strong{geom_gradient_field}, the
color aesthetic is mapped to \code{after_stat(avg_spd)}.}
}
}

\examples{
Si <- matrix(c(1, 0.75, 0.75, 1), nrow = 2)
f <- function(u) exp(-as.numeric(u \%*\% solve(Si) \%*\% u) / 2) / (2 * pi * det(Si))

ggplot() +
  geom_gradient_field(fun = f, xlim = c(-3, 3), ylim = c(-3, 3))

\donttest{
df <- expand.grid(x = seq(-3, 3, 0.1), y = seq(-3, 3, 0.1)) |>
  transform(fxy = apply(cbind(x, y), 1, f))

ggplot() +
  geom_raster(aes(x, y, fill = fxy), data = df) +
  geom_gradient_field(fun = f, xlim = c(-3, 3), ylim = c(-3, 3)) +
  coord_equal()

fxy <- function(x, y) apply(cbind(x,y), 1, f)

ggplot() +
  ggdensity::geom_hdr_fun(fun = fxy, xlim = c(-3,3), ylim = c(-3,3)) +
  geom_gradient_field(fun = f, xlim = c(-3,3), ylim = c(-3,3)) +
  coord_equal()

  library("ggdensity")
  fxy <- function(x, y) apply(cbind(x, y), 1, f)
  fxy(1, 2)
  f(1:2)

  ggplot() +
    geom_hdr_fun(fun = fxy, xlim = c(-3, 3), ylim = c(-3, 3)) +
    geom_gradient_field(fun = f, xlim = c(-3, 3), ylim = c(-3, 3)) +
    coord_equal()
}
}
