% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endogenousstats.R
\name{get_zero_dummy}
\alias{get_zero_dummy}
\title{Create a dummy variable to encode zero values of another variable.}
\usage{
get_zero_dummy(dat, name = NULL, zero_values = NULL)
}
\arguments{
\item{dat}{matrix, the predictor for which the zero values should be recoded.}

\item{name}{optional character, the name of the predictor to create a named list}

\item{zero_values}{optional numeric, the value to assign to the zero values of `dat`
in the dummy variable. It defaults to e to simplify the interpretation of the results.}
}
\value{
a possibly named list of two matrices. The first one is the recoded version of `dat` where all zeroes
are changed to 1. The second is the dummy variable such that dummy[dat==0] <- zero_values and 1
otherwise.
}
\description{
Use this to substitute zero-values in your nrm values. Zero values in the predictors
are recognized in the gHypEG regression as structural zeroes. To ensure this
does not happen, please recode your zero-values in all your predictors,
ideally using a dummy variable fitting an optimal value for the zeroes.
This function takes a predictor that needs to be recoded and returns a list
containing two matrices. The first one contains the original predictor
recoded such that all zero values are 1 (and thus do not impact the model).
The second one consist of a matrix with 1 where the original predictor was
different from 0, and `zero_values` where the original predictor was 0.
If `zero_values` is not specified, it is fixed to e to simplify the interpretation
of the results.
}
\seealso{
\code{\link{reciprocity_stat}} or \code{\link{sharedPartner_stat}}
}
