% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gie_getumm.R
\name{gie_getumm}
\alias{gie_getumm}
\title{gie_getumm -- Download info on IIP urgent market messages}
\usage{
gie_getumm(
  from = NULL,
  to = NULL,
  published_date = NULL,
  eic_entity = NULL,
  eic_participant = NULL,
  eic_asset = NULL,
  status = NULL,
  direction = NULL,
  timeout = 3,
  size = 300,
  apikey = Sys.getenv("GIE_APIKEY")
)
}
\arguments{
\item{from}{Character. Date the UMM is being in place from (format: YYYY-MM-DD).}

\item{to}{Character. Date the UMM is being in place to (format: YYYY-MM-DD).}

\item{published_date}{Character. Filter by publication date of UMM. Can be partial (e.g.: "2025-02-25", "2025-02", "2025").}

\item{eic_entity}{Character. EIC code of the UMM issuing entity.}

\item{eic_participant}{Character. EIC code of the UMM issuing market participant.}

\item{eic_asset}{Character. EIC code of the asset the UMM is issued for.}

\item{status}{Character. Can be 'active', 'inactive' or 'dismissed'. Default is all.}

\item{direction}{Character. Direction of gas flows. Can be "entry" or "exit". Default is all.}

\item{timeout}{Numeric. If the amount of pages of your request exceeds 60, a timeout \cr
will be enforced to prevent the API from timing out. Defaults to 3 seconds, any \cr
values must be set in seconds, too.}

\item{size}{Integer. The number of results per page.}

\item{apikey}{Character. Your personal API key.}
}
\value{
A nested list with UMMs for your specific API query to IIP. Note: The results are not parsed for there are too many data variants a user could want.
}
\description{
Function to download urgent market messages (UMM) from the Inside Information Platform (IIP)
}
\examples{
\dontrun{
umm <- gie_getumm(from = "2024-01-01", to = "2024-12-31")
}

}
