% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{glam}
\alias{glam}
\title{Generalized Linear/Additive Model (GLAM)}
\usage{
glam(x, y, model, family, intercept = TRUE, tol = 1e-08, max_iter = 100)
}
\arguments{
\item{x}{a \code{matrix} with covariate data.}

\item{y}{a \code{vector} of responses.}

\item{model}{a string stating whether a GLM (\code{"linear"}) or GAM (\code{"additive"}) should be fit.}

\item{family}{the distributional family from which to model response. Options are
\code{"beta"}, \code{"binomial"} (GLM only), \code{"poisson"}, and \code{"gamma"}.}

\item{intercept}{a \code{logical} indicating whether an intercept is desired. Only applicable when
\code{model = "linear"}. Default is \code{TRUE}.}

\item{tol}{the tolerance for convergence. Must be positive. Default is \code{1e-8}.}

\item{max_iter}{an \code{integer} specifying the maximum number of allowed iterations. Default is \code{100}.}
}
\value{
The output is a \code{list} containing:\tabular{ll}{
\code{eta} \tab a \code{vector} of un-transformed fitted values. \cr
\tab \cr
\code{mu} \tab a \code{vector} of transformed fitted values. \cr
\tab \cr
\code{num_iter} \tab the number of iterations until convergence or timeout. \cr
\tab \cr
\code{dev} \tab the convergence criteria achieved at the end. \cr
\code{coef} \tab a numeric vector of estimated coefficients
(only applicable when \code{model = "linear"}). \cr
}
}
\description{
\code{glam} fits Generalized Linear Models (GLMs) and Generalized Additive Models (GAMs).
}
\details{
This is a function for training and fitting Generalized Linear Models (GLMs) and
Generalized Additive Models (GAMs). It implements these models using Iterative Reweighted Least Squares
(IRLS) described in Hastie and Tibshirani 1990 (\url{doi:10.1214/ss/1177013604}). This function supports Beta
regression, Logistic regression, Poisson regression, and Gamma regression (Logistic GAMs are
currently not supported).
}
\examples{
# generate random inputs
set.seed(10)
n <- 200
X <- sort(runif(n))
# Beta GLM vs. GAM
Y <- (X - 0.5)^2 + 0.5 + rnorm(n, sd = 1e-1)
beta_glm <- glam(cbind(X, X^2), Y, model = "linear", family = "beta")
beta_gam <- glam(cbind(X, X^2), Y, model = "additive", family = "beta")
plot(X, Y, pch = 20, xlab = "X", ylab = "Y", main = "Beta Regression Example")
lines(X, beta_glm$mu, col = "red", lwd = 2)
lines(X, beta_gam$mu, col = "blue", lwd = 2)
legend("bottomright", legend = c("GLM", "GAM"), col = c("red", "blue"), lwd = 2)
}
