% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotUtrecht2019dataset.R
\name{plotUtrecht2019dataset}
\alias{plotUtrecht2019dataset}
\title{Plot variables from the utrecht2019dataset}
\usage{
plotUtrecht2019dataset(name1, name2 = NA, savePath = NA)
}
\arguments{
\item{name1}{Character. The name of the first variable to plot.}

\item{name2}{Character (optional). The name of the second variable for bivariate plots. Default is NA.}

\item{savePath}{Character (optional). File path where the plot should be saved.
Default is NULL which means no plot will be saved.
To save a plot using all the default options put an empty string.
The format must be: 'filepath/filename.extension' where:
\itemize{
\item filepath is the directory (must already exist), default is the working directory;
\item filename is the name of the file, default to 'plot_utrecht2019dataset_var1_var2_timestamp.png';
\item extension must be one of the supported 'ggsave' extensions and must be specified, unless using the default file name.
}}
}
\value{
A 'ggplot2' object representing the generated plot.
If the specified variables are not found in the dataset, returns a warning.
}
\description{
This function creates a plot of one or two variables from the 'utrecht2019dataset' dataframe.
It automatically chooses the appropriate plot type based on the variable types and
it can export and save the plot by specifying the directory, filename and extension.
Provided variable names need to be in the dataset, otherwise an error will be launched.
The function makes it easy to plot univariate and bivariate plots while offering a quick way to save and export them.
}
\details{
The function supports the following plotting logic:
\itemize{
\item If only 'name1' is provided:
\itemize{
\item Numeric/integer variable → Histogram.
\item Character/factor variable → Bar plot.
}
\item If both 'name1' and 'name2' are provided:
\itemize{
\item One numeric/integer and one categorical → Boxplot.
\item Both categorical → Grouped bar plot.
}
}
}
\examples{
# Univariate plot without saving
plotUtrecht2019dataset("SVZ_status_nocontact0_contact1")

# Bivariate plot without saving
plotUtrecht2019dataset("post_surgery_therapy_none0_monotherapy1_RTandTMZ2", "OS_months")

\donttest{
# Bivariate plot saved in the specified directory with the chosen name and extension
plotUtrecht2019dataset("age_years", "KPS_less70.0_more70.1", savePath = NA)

# Univariate plot save in the working directory with the chosen name and extension
plotUtrecht2019dataset("survived_yes1_no0", savePath = NA)

# Bivariate plot save in the path directory using the default name
plotUtrecht2019dataset("survived_yes1_no0", savePath = NA)
}

}
\seealso{
\code{\link[DataExplorer:plot_bar]{DataExplorer::plot_bar()}}, \code{\link[DataExplorer:plot_histogram]{DataExplorer::plot_histogram()}}, \link[DataExplorer:plot_boxplot]{DataExplorer::plot_boxplot}, \code{\link[=savePlot]{savePlot()}}
}
