#' @name felinedata
#' @title  felinedata -- Chlamydial Infection in Cats
#'
#'@description In a study conducted by Sykes et al. (1999), the risk factors for Chlamy, a chlamydial infection in cats, were investigated. The analysis considered important variables such as FHV1 (Herpes virus infection), Season, Conjunctivitis (Conj), and Age group. Season was coded from 1 to 4 to represent the seasons, FHV1 was binary (1 for infected cats, 0 for non-infected cats), Conj was binary (1 if present, 0 if absent), and Age group was categorized into specific ranges. The original dataset had 462 observations, with around 20% missing values. After removing missing values, the analysis was conducted with a sample size of 371. The fitted model included Chlamy as the outcome variable, with FHV1, Season, Conj, and Age group as predictors, treating Age group and Season as class variables with a base value of 1.

#'
#' @references
#' Cytel Inc (2010). LogXact 9 User Manual: Discrete Regression Analysis. Cambridge, Massachusetts: Cytel Inc.
#'
#' Maiti, T., Pradhan, V. (2009). Bias reduction and a solution of separation of logistic regression with missing covariates. Biometrics, 65, 1262-1269.
#'
#' Pradhan, V., Nychka, D. and Bandyopadhyay, S. (2024). Beyond the Odds: Fitting Logistic Regression with Missing Data in Small Samples (submitted).
#'
#' Sykes, J. E., Anderson, G. A., Studdert, V. P., and Browning, G. F. (1999). Prevalence of feline Chlamydia psittaci and feline her- pesvirus 1 in cats with upper respiratory tract disease. Journal of Veterinary Internal Medicine 13, 153–162.
#' @examples
#'data("felinedata")
#'expanded_data <- felinedata[rep(seq_len(nrow(felinedata)), felinedata$GrpSize), ]
#'fit <- glm(chlamy ~ FHV1+Season+Conj+Agegrp, data=expanded_data, family="binomial")
#' # High Std. Error values indicate the model did not converge for complete case analysis
#' summary(fit)
#'
#' #Fitting the model with emforbeta using Ibrahim (1990)
#' fit2 <- emforbeta(chlamy ~ FHV1+Season+Conj+Agegrp, data=expanded_data, family="binomial")
#' # High Std. Error values indicate the model did not converge for complete case analysis
#' summary(fit2$mfit)
#'
#' #Fitting the model with Ibrahim (1990) and Firth correction (Maiti and Pradhan (2009))
#' fit2 <- emforbeta(chlamy ~ FHV1+Season+Conj+Agegrp,
#'                   data=expanded_data, family="binomial", method = "brglmFit")
#' summary(fit2$mfit)
"felinedata"
