% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_abnorm_hist.r
\name{get_abnorm_hist}
\alias{get_abnorm_hist}
\alias{get_abnorm_hist.exp_score}
\alias{get_abnorm_hist.exp_voi}
\alias{get_abnorm_hist.exp_doi}
\title{Compute abnormal changes in data - historic baseline}
\usage{
get_abnorm_hist(data, ...)

\method{get_abnorm_hist}{exp_score}(
  data,
  train_win = 12,
  train_break = 0,
  type = c("obs", "sad", "trd"),
  ...
)

\method{get_abnorm_hist}{exp_voi}(
  data,
  train_win = 12,
  train_break = 0,
  type = c("obs", "sad", "trd"),
  ...
)

\method{get_abnorm_hist}{exp_doi}(
  data,
  train_win = 12,
  train_break = 0,
  measure = c("gini", "hhi", "entropy"),
  ...
)
}
\arguments{
\item{data}{Object of class \code{exp_score}, \code{exp_voi} or
\code{exp_doi} generated through \code{export_...} functions.}

\item{...}{Further arguments passed to or from other methods.}

\item{train_win}{Object of type \code{numeric}. Length of rolling average
training window in months. Defaults to 12.}

\item{train_break}{Object of type \code{numeric}. Length of break between
rolling average training window and date in months. Defaults to 1.}

\item{type}{Object of type \code{character} indicating the type of time
series-column from data_score, takes either \emph{obs}, \emph{sad}, or
\emph{trd}. Defaults to \emph{"obs"}.}

\item{measure}{Object of type \code{character} indicating the measure used
for DOI computation for which abnormal changes should be analyzed. Takes
either \emph{gini}, \emph{hhi}, or \emph{entropy}. Defaults to \emph{"gini"}.}
}
\value{
The functions export and filter the respective database tables and return
objects of class \verb{"tbl_df", "tbl", "data.frame"}.
\itemize{
\item Input class \code{exp_score} computes abnormal changes in search
scores with columns keyword, location, date, control, object, score,
score_abnorm, quantile. Object of class
\code{c("abnorm_score", "data.frame")}.
\item Input class \code{exp_voi} computes abnormal changes in VOI with
columns keyword, date, control, object, voi, voi_abnorm, quantile. Object
of class \code{c("abnorm_voi", "data.frame")}.
\item Input class \code{exp_doi} computes abnormal changes in DOI with
columns keyword, locations, date, control, object, doi, doi_abnorm,
quantile. Object of class \code{c("abnorm_doi", "data.frame")}.
}
}
\description{
The function allows to compute changes in search scores, voi, and doi and
shows percentile of changes to identify abnormal changes. In combination with
various \emph{write} functions in R, the functions allow exports from the
database to local files.
}
\details{
The function computes abnormal changes in search scores, VOI, or DOI for each
date. We define "abnormal" in terms of deviation from a historic baseline
value. To compute the historic baseline value, the function computes a moving
average. Users can specify the window for moving average training
\code{train_win} and a break between training and the given date
\code{train_break}. Abnormal changes are the difference between the moving
average and the respective search score, VOI, or DOI. To highlight abnormal
changes, the function computes a historic percentile rank for each abnormal
change within the distribution of abnormal changes. Low percentile ranks
signify abnormally high negative changes. High percentile ranks signify
abnormally high positive changes.
The function uses the output from \code{export_...} functions as input. As
\code{get_abnorm_hist} offers no additional filters, users are advised to use
filters in the \code{export_...} functions or to pre-process data before
using \code{get_abnorm_hist}.
}
\examples{
\dontrun{
data <- export_score(keyword = "amazon")
get_abnorm_hist(data, train_win = 12, train_break = 0, type = "obs")

data <- export_voi(keyword = "amazon")
get_abnorm_hist(data, train_win = 12, train_break = 0, type = "obs")

data <- export_score(keyword = "amazon")
get_abnorm_hist(data, train_win = 12, train_break = 0, measure = "gini")
}

}
\seealso{
\itemize{
\item \code{\link[=export_score]{export_score()}}
\item \code{\link[=export_voi]{export_voi()}}
\item \code{\link[=export_doi]{export_doi()}}
\item \code{\link[dplyr:filter]{dplyr::filter()}}
}
}
