% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_do.R
\name{glue_do}
\alias{glue_do}
\alias{glue_func}
\alias{glue_stop}
\alias{glue_print}
\alias{glue_message}
\alias{glue_warning}
\alias{glue_cat}
\alias{glue_return}
\alias{glue_write}
\title{Glue Wrapper Functions}
\usage{
glue_do(.x, ..., .envir = parent.frame(), .func)

glue_func(.x, .func, ..., .envir = parent.frame())

glue_stop(.x, ..., .envir = parent.frame(), .func = stop)

glue_print(.x, ..., .envir = parent.frame(), .func = print)

glue_message(.x, ..., .envir = parent.frame(), .func = message)

glue_warning(.x, ..., .envir = parent.frame(), .func = warning)

glue_cat(.x, ..., .envir = parent.frame(), .func = cat)

glue_return(.x, ..., .envir = parent.frame(), .func = identity)

glue_write(.x, file, ..., .envir = parent.frame(), .func = writeLines)
}
\arguments{
\item{.x}{The glue string containing expressions to be evaluated.}

\item{...}{Additional arguments passed to `glue`.}

\item{.envir}{The environment where the expressions in the glue string are evaluated. Defaults to `parent.frame()`.}

\item{.func}{A function to execute with the result of the evaluated glue string.}

\item{file}{file file}
}
\value{
Returns the result of executing `.func` with the evaluated glue string.
}
\description{
These functions are used to pass a glue string to a function and execute it.
}
\section{Functions}{
\itemize{
\item \code{glue_func()}: Executes a custom function with the evaluated glue string.

\item \code{glue_stop()}: Executes the `stop` function with the evaluated glue string.

\item \code{glue_print()}: Executes the `print` function with the evaluated glue string.

\item \code{glue_message()}: Executes the `message` function with the evaluated glue string.

\item \code{glue_warning()}: Executes the `warning` function with the evaluated glue string.

\item \code{glue_cat()}: Executes the `cat` function with the evaluated glue string.

\item \code{glue_return()}: Evaluates the glue string and returns the result.

\item \code{glue_write()}: Initializes a file connection and writes the evaluated glue string to it.

}}
\examples{
world <- 'mars'
glue_message('HELLO {world}!')

}
