% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-construct-mordent.R
\name{Mordent}
\alias{Mordent}
\title{Create \code{Mordent} Object}
\usage{
Mordent(i, to = NULL, inverted = NULL, long = NULL, ornament = NULL)
}
\arguments{
\item{i}{A single positive integer, which represents the position
of the mordent in a musical line.}

\item{to}{Optional. A single character or a single positive integer,
which indicates the musical line where to add the mordent.}

\item{inverted}{Optional. A single logical, which indicates whether the
mordent is inverted or not. The default value is \code{FALSE}. See MusicXML
specification of \href{https://w3c.github.io/musicxml/musicxml-reference/elements/mordent/}{mordent} and
\href{https://w3c.github.io/musicxml/musicxml-reference/elements/inverted-mordent/}{inverted mordent}.}

\item{long}{Optional. A single logical, which indicates whether the
mordent is long or not. The default value is \code{FALSE}.}

\item{ornament}{Optional. A single character, which can be \code{"left up"},
\code{"left down"}, \code{"right up"}, or \code{"right down"}. It indicates the
direction of the mordent's left or right part.}
}
\value{
A list of class \code{Mordent}.
}
\description{
Create a \code{Mordent} object to represent a mordent ornament.
}
\examples{
# Create a mordent
mordent <- Mordent(1)
mordent

# Add it to a `Music`
music <- Music() + Meter(4, 4) + Line(c("C4", "D4")) + mordent
music

# Generate the music score
if (interactive()) {
  show(music)
}
}
\seealso{
\code{\link[=+.Music]{+.Music()}} for adding a \code{Mordent} to a \code{Music} object.
}
