% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-construct-notehead.R
\name{Notehead}
\alias{Notehead}
\title{Create \code{Notehead} Object}
\usage{
Notehead(
  i,
  j = NULL,
  to = NULL,
  shape = NULL,
  color = NULL,
  filled = NULL,
  bracket = NULL
)
}
\arguments{
\item{i}{A single positive integer, which represents the position
of the note in a musical line.}

\item{j}{Optional. A single positive integer, which represents the
position of the note in a chord.}

\item{to}{Optional. A single character or a single positive integer,
which indicates the musical line where to apply the \code{Notehead}.}

\item{shape}{Optional. A single character which represents the shape
of the note's head. See
\href{https://w3c.github.io/musicxml/musicxml-reference/data-types/notehead-value/}{the MusicXML specification}
for all shapes. Unfortunately, not all shapes are supported in MuseScore.}

\item{color}{Optional. A single character which represents the color
of the note's head. It must be in the hexadecimal RGB or ARGB format.}

\item{filled}{Optional. A single logical, which indicates whether the
note's head is filled or hollow.}

\item{bracket}{Optional. A single logical, which indicates whether the
note's head is enclosed in brackets.}
}
\value{
A list of class \code{Notehead}.
}
\description{
Create a \code{Notehead} object to customize the appearance of a note's head.
}
\examples{
# Create a `Notehead`
notehead <- Notehead(1, shape = "diamond", color = "#800080")
notehead

# Add it to a `Music`
music <- Music() + Meter(4, 4) + Line(c("C4", "D4")) + notehead
music

# Generate the music score
if (interactive()) {
  show(music)
}
}
\seealso{
\code{\link[=+.Music]{+.Music()}} for adding a \code{Notehead} to a \code{Music} object.
}
