% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmnl.methods.R
\name{effect.gmnl}
\alias{effect.gmnl}
\title{Get the Conditional Individual Coefficients}
\usage{
effect.gmnl(x, par = NULL, effect = c("ce", "wtp"), wrt = NULL, ...)
}
\arguments{
\item{x}{an object of class \code{gmnl}.}

\item{par}{a string giving the name of the variable with a random parameter.}

\item{effect}{a string indicating what should be computed: the conditional expectation of the individual coefficients "\code{ce}", or the conditional expectation of the willingness-to-pay "\code{wtp}".}

\item{wrt}{a string indicating with respect to which variable the willingness-to-pay should be computed.}

\item{...}{further arguments. Ignorred.}
}
\value{
A named list where "\code{mean}" contains the individuals' conditional mean for the random parameter or willingness-to-pay, and where "\code{sd.est}" contains standard errors.
}
\description{
This a helper function to obtain the individuals' conditional estimate of the either random parameters or willingness-to-pay.
}
\examples{
\dontrun{
## Data
data("TravelMode", package = "AER")
library(mlogit)
TM <- mlogit.data(TravelMode, choice = "choice", shape = "long", 
                 alt.levels = c("air", "train", "bus", "car"), chid.var = "individual")
                 
## MIXL model with observed heterogeneity
mixl.hier <- gmnl(choice ~ vcost + gcost + travel + wait | 1 | 0 | income + size - 1,
                 data = TM,
                 model = "mixl",
                 ranp = c(travel = "t", wait = "n"),
                 mvar = list(travel = c("income","size"), wait = c("income")),
                 R = 30,
                 haltons = list("primes"= c(2, 17), "drop" = rep(19, 2)))
                 
## Get the individuals' conditional mean and their standard errors for lwage
bi.travel <- effect.gmnl(mixl.hier, par = "travel", effect = "ce")
summary(bi.travel$mean)
summary(bi.travel$sd.est)

## Get the individuals' conditional WTP of travel with respect to gcost
wtp.travel <- effect.gmnl(mixl.hier, par = "travel", effect = "wtp", wrt = "gcost")
summary(wtp.travel$mean)
summary(wtp.travel$sd.est)
} 
}
\references{
\itemize{
\item Greene, W. H. (2012). Econometric Analysis, Seventh Edition. Pearson Hall.
\item Train, K. (2009). Discrete Choice Methods with Simulation. Cambridge University Press.
}
}
\seealso{
\code{\link[gmnl]{gmnl}} for the estimation of multinomial Logit models with individual parameters.
}
\author{
Mauricio Sarrias.
}
