% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeCheck.R
\name{codeCheck}
\alias{codeCheck}
\title{codeCheck}
\usage{
codeCheck(
  path = ".",
  modulepath = "modules",
  core_files = c("core/*.gms", "main.gms"),
  returnDebug = FALSE,
  interactive = FALSE,
  test_switches = TRUE,
  strict = FALSE,
  details = FALSE
)
}
\arguments{
\item{path}{path of the main folder of the model}

\item{modulepath}{path to the module folder relative to "path"}

\item{core_files}{list of files that belong to the core (wildcard expansion is supported)}

\item{returnDebug}{If TRUE additional information will be returned useful for
debugging the codeCheck function}

\item{interactive}{activates an interactive developer mode in which some of
the warnings can be fixed interactively.}

\item{test_switches}{(boolean) Should realization switches in model core be tested for completeness?
Usually set to TRUE but should be set to FALSE for standalone models only using a subset of
existing modules}

\item{strict}{(boolean) test strictness. If set to TRUE warnings from codeCheck will stop calculations
at the end of the analysis. Useful to enforce clean code.}

\item{details}{(boolean) If activated the function will return more detailed output. Besides interface information
it will provide a table containing all declarations in the code, an appearance table listing the appearance of all
objects in the code and information about the existing modules. The format is
list(interfaceInfo,declarations,appearance,modulesInfo). This setting will be ignored
when returnDebug is set to TRUE.}
}
\value{
A list of all modules containing the interfaces for each module. Or more detailed output if either
\code{details} or \code{returnDebug} is set to TRUE.
}
\description{
Checks GAMS code for consistency. Throws out warnings if something is wrong
in the code and returns a list containing the interfaces of each module of
the code.
}
\details{
Additional settings can be provided via a yaml file ".codeCheck" in the main
folder of the model. Currently supported settings are:
- capitalExclusionList: a list of names that should be ignored when checking
for unified capitalization of variables
}
\examples{
# check code consistency of dummy model
codeCheck(system.file("dummymodel", package = "gms"))

}
\seealso{
\code{\link{codeExtract}},\code{\link{readDeclarations}}
}
\author{
Jan Philipp Dietrich
}
