% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expected_variance_effect.R
\name{expected.variance.effect}
\alias{expected.variance.effect}
\title{Expected variance effect from additive effect}
\usage{
expected.variance.effect(maf, beta_add)
}
\arguments{
\item{maf}{Minor allele frequency of the variant, should be in the range 0 to 0.5.}

\item{beta_add}{Additive effect of the variant, should be in the range 0 to 3.5.
This variable can be a vector of values.}
}
\value{
The expected variance effect for the variant from the given maf, beta combination.
}
\description{
This function interpolates data from a simple simulation to give an estimate
of the variance effect induced by an additive effect. The simulation code
is stored under inst/raw/. We assume that the trait has been inverse normal
transformed. Under the simulation, there is no variance effect, so the variance
effect is fully induced by the inverse normal transform.
}
\examples{
maf <- 0.1
beta_val <- 0.3
expected_var <- expected.variance.effect(maf, beta_val)

beta_vec <- seq(0.1,2, length.out = 20)
expected_var <- expected.variance.effect(maf, beta_vec)
}
