% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dominance_model.R
\name{dominance.calc}
\alias{dominance.calc}
\title{Genetic dominance effects}
\usage{
dominance.calc(
  qt,
  g,
  round_imputed = FALSE,
  covariates = as.data.frame(matrix(0, nrow = 0, ncol = 0))
)
}
\arguments{
\item{qt}{A numeric vector}

\item{g}{A vector with (possibly imputed) genotype values. All entries should be larger than 0 and smaller than 2.}

\item{round_imputed}{A boolian variable determining whether imputed genotype values should be rounded to the nearest integer in the analysis}

\item{covariates}{A dataframe containing any covariates that should be used; one column per covariate.}
}
\value{
A list with the dominanc effect and corresponding standard error, t statistic and p-value
}
\description{
This function estimates the dominance effect of a genetic variant on a quantitatvie trait
Nothing fancy here. We apply a simple linear regression model to estimate dominance effects.
We include a linear term, coded as 0,1 and 2 for non-carriers, heterozygotes and homozygous carriers of the effect allele.
We also include a dominance term, coded as 1 for homozygous carriers and 0 for others.
Effect size and significance is based on the dominance term.
}
\examples{
g_vec <- rbinom(100000, 2, 0.3)
qt_vec <- rnorm(100000) + 0.2 * g_vec^2
res <- dominance.calc(qt_vec, g_vec)
}
