% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/racurves.r
\name{racurves}
\alias{racurves}
\title{Multiple rank-abundance curves}
\usage{
racurves(matrix, main = "Rank-abundance diagram", bw = TRUE)
}
\arguments{
\item{matrix}{Community data, a matrix-like object with samples in rows and species in columns. Rank-abundance curves are drawn for all selected rows (samples).}

\item{main}{The main title (optional).}

\item{bw}{If set on \code{FALSE} the lines will be drawn in colors instead of black/white lines with different line types.}
}
\value{
No return value, only diagram.
}
\description{
This function draws multiple rank-abundance curves for selected samples into one diagram.
If you wish to draw a simple rank-abundance curve see \code{\link{racurve}}.
}
\section{Details}{

Rank abundance curves or Whittaker plots (see \cite{Whittaker 1965}) are used to display relative species abundance as biodiversity component.
They are a means to visualize species richness and species evenness.

The axes of the diagram will be scaled according automatically.
As the line type is used to differentiate between samples, a maximum of 6 curves per diagram is feasible in black/white mode.
}

\examples{
## Draw multiple rank-abundance curves for selected samples
racurves(schedenveg[c(1,7,20,25), ])

## Draw multiple rank-abundance curves for selected samples with coloured lines
racurves(schedenveg[c(1,7,20,25), ], bw = FALSE)
}
\references{
Whittaker, R. H. (1965). Dominance and Diversity in Land Plant Communities: Numerical relations of species express the importance of competition in community function and evolution. \emph{Science} \strong{147 :} 250-260. \doi{10.1126/science.147.3655.250}
}
\seealso{
\code{\link{racurve}} for a simple curve and \code{\link[BiodiversityR]{rankabundance}} from package \code{BiodiversityR} for a more sophisticated function
}
\author{
Friedemann von Lampe
}
