% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/folders.R
\name{gtm_folders_list}
\alias{gtm_folders_list}
\title{List all containers in an account}
\usage{
gtm_folders_list(account_id, container_id, workspace_id)
}
\arguments{
\item{account_id}{Account Id}

\item{container_id}{Container Id}

\item{workspace_id}{Workspace Id}
}
\description{
This returns a dataframe containing all the folder in a workspace
If you want to get the information for a single folder, use \code{gtm_folders_get}
}
\examples{

\dontrun{
accountId <- 1234567
containerId <- 7654321
workspaceId <- 3

folders <- gtm_folders_list(accountId, containerId, workspaceId)

}

}
\seealso{
\url{https://developers.google.com/tag-platform/tag-manager/api/v2/reference/accounts/containers/workspaces/folders/list}

Other folder functions: 
\code{\link{gtm_folders_create}()},
\code{\link{gtm_folders_delete}()},
\code{\link{gtm_folders_entities}()},
\code{\link{gtm_folders_get}()},
\code{\link{gtm_folders_move}()},
\code{\link{gtm_folders_revert}()},
\code{\link{gtm_folders_update}()}
}
\concept{folder functions}
