% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\name{gtm_variables_delete}
\alias{gtm_variables_delete}
\title{Delete a variable}
\usage{
gtm_variables_delete(
  account_id,
  container_id,
  workspace_id,
  variable_id,
  force = c(TRUE, FALSE)
)
}
\arguments{
\item{account_id}{Account Id}

\item{container_id}{Container Id}

\item{workspace_id}{Workspace Id}

\item{variable_id}{Variable Id}

\item{force}{Force deletion without user input}
}
\description{
This deletes a variable in a GTM workspace
}
\examples{

\dontrun{
accountId <- 1234567
containerId <- 7654321
workspaceId <- 10
variableId <- 30

gtm_variables_delete(accountId, containerId, workspaceId, variableId)

# This will delete tag \%s. Are you sure you want to continue?

#  1: Yes
#  2: No

# Selection: 1

# Variable 30 has been deleted.

variableId = 31

gtm_variables_delete(accountId, containerId, workspaceId, variableId, "TRUE")

# Variable 31 has been deleted.

}

}
\seealso{
\url{https://developers.google.com/tag-platform/tag-manager/api/v2/reference/accounts/containers/workspaces/variables/delete}

Other variable functions: 
\code{\link{gtm_variables_create}()},
\code{\link{gtm_variables_get}()},
\code{\link{gtm_variables_list}()},
\code{\link{gtm_variables_revert}()},
\code{\link{gtm_variables_update}()}
}
\concept{variable functions}
