% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspaces.R
\name{gtm_workspaces_list}
\alias{gtm_workspaces_list}
\title{List all workspaces a user has accesss to}
\usage{
gtm_workspaces_list(account_id, container_id)
}
\arguments{
\item{account_id}{Account Id}

\item{container_id}{Container Id}
}
\description{
This will return a data frame all your available workspaces in a given container.
If you want to get the information for a single workspace, use \code{gtm_workspaces_get}
}
\examples{

\dontrun{
accountId <- 1234567
containerId <- 7654321

workspaces <- gtm_workspaces_list(accountId, containerId)

}

}
\seealso{
\url{https://developers.google.com/tag-platform/tag-manager/api/v2/reference/accounts/containers/workspaces/list}

Other workspace functions: 
\code{\link{gtm_workspaces_create}()},
\code{\link{gtm_workspaces_delete}()},
\code{\link{gtm_workspaces_get}()},
\code{\link{gtm_workspaces_preview}()},
\code{\link{gtm_workspaces_resolve}()},
\code{\link{gtm_workspaces_status}()},
\code{\link{gtm_workspaces_submit}()},
\code{\link{gtm_workspaces_sync}()},
\code{\link{gtm_workspaces_update}()}
}
\concept{workspace functions}
