% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zones.R
\name{gtm_zones_revert}
\alias{gtm_zones_revert}
\title{Reverts a zone to its original state}
\usage{
gtm_zones_revert(account_id, container_id, workspace_id, zone_id)
}
\arguments{
\item{account_id}{Account Id}

\item{container_id}{Container Id}

\item{workspace_id}{Workspace Id}

\item{zone_id}{Zone Id}
}
\description{
This reverts a zone back to its original, unmodified state.
}
\examples{

\dontrun{
accountId <- 1234567
containerId <- 7654321
workspaceId <- 11
zoneId <- 5

zone <- gtm_zones_revert(accountId, containerId, workspaceId, zoneId)
}

}
\seealso{
\url{https://developers.google.com/tag-platform/tag-manager/api/v2/reference/accounts/containers/workspaces/zones/revert}

Other zone functions: 
\code{\link{gtm_zones_create}()},
\code{\link{gtm_zones_delete}()},
\code{\link{gtm_zones_get}()},
\code{\link{gtm_zones_list}()},
\code{\link{gtm_zones_update}()}
}
\concept{zone functions}
