% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11-grafos-NPdif.R
\encoding{UTF-8}
\name{crossover_sequences}
\alias{crossover_sequences}
\title{Crossover of sequences}
\usage{
crossover_sequences(s1, s2, cpoint = NA)
}
\arguments{
\item{s1}{Sequence}

\item{s2}{Sequence of the same length as s1}

\item{cpoint}{Crossover point, an integer between 1 and
length(s1)-1.  Defaults to NA, in which case it will be
randomly chosen}
}
\value{
A two-row matrix.  Rows are the offsprings produced by the
crossover
}
\description{
Crossover sequence operation for use in the genetic cut-search algorithm.
}
\details{
This operation takes two sequences of the same length "n" and
splits them in two at a crossover point between 1 and "n-1".
Then it produces two "offsprings" by interchanging the pieces
and gluing them together.

The crossover point can be specified in argument cpoint.  By
providing NA (the default), cpoint is chosen randomly.

Note that this crossover operation is the "classic" crossover
included in the original genetic algorithm, and it is adequate
when applied to binary sequences.  However, when applied to
permutations, the result of this function can have repeated
elements; hence, it is not adequate for the TSP.
}
\examples{
set.seed(1)
s1 <- sample(0:1, 10, replace = TRUE)
s2 <- sample(0:1, 10, replace = TRUE)
crossover_sequences(s1, s2)

set.seed(1)
s1 <- sample(1:10, 10)
s2 <- sample(1:10, 10)
crossover_sequences(s1, s2, cpoint = 5)

}
\seealso{
\link{search_cut_genetic} genetic algorithm cut-search,
\link{mutate_binary_sequence} binary sequence mutation
}
\author{
Cesar Asensio
}
