% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpb.Booster.R
\name{gpb.dump}
\alias{gpb.dump}
\title{Dump GPBoost model to json}
\usage{
gpb.dump(booster, num_iteration = NULL)
}
\arguments{
\item{booster}{Object of class \code{gpb.Booster}}

\item{num_iteration}{number of iteration want to predict with, NULL or <= 0 means use best iteration}
}
\value{
json format of model
}
\description{
Dump GPBoost model to json
}
\examples{
\donttest{
library(gpboost)
data(agaricus.train, package = "gpboost")
train <- agaricus.train
dtrain <- gpb.Dataset(train$data, label = train$label)
data(agaricus.test, package = "gpboost")
test <- agaricus.test
dtest <- gpb.Dataset.create.valid(dtrain, test$data, label = test$label)
params <- list(objective = "regression", metric = "l2")
valids <- list(test = dtest)
model <- gpb.train(
  params = params
  , data = dtrain
  , nrounds = 10L
  , valids = valids
  , min_data = 1L
  , learning_rate = 1.0
  , early_stopping_rounds = 5L
)
json_model <- gpb.dump(model)
}
}
