% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpb.Dataset.R
\name{dim.gpb.Dataset}
\alias{dim.gpb.Dataset}
\title{Dimensions of an \code{gpb.Dataset}}
\usage{
\method{dim}{gpb.Dataset}(x, ...)
}
\arguments{
\item{x}{Object of class \code{gpb.Dataset}}

\item{...}{other parameters}
}
\value{
a vector of numbers of rows and of columns
}
\description{
Returns a vector of numbers of rows and of columns in an \code{gpb.Dataset}.
}
\details{
Note: since \code{nrow} and \code{ncol} internally use \code{dim}, they can also
be directly used with an \code{gpb.Dataset} object.
}
\examples{
\donttest{
data(agaricus.train, package = "gpboost")
train <- agaricus.train
dtrain <- gpb.Dataset(train$data, label = train$label)

stopifnot(nrow(dtrain) == nrow(train$data))
stopifnot(ncol(dtrain) == ncol(train$data))
stopifnot(all(dim(dtrain) == dim(train$data)))
}
}
